/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.StatsQueryRequest;
import org.hawkular.metrics.api.jaxrs.handler.observer.MetricCreatedObserver;
import org.hawkular.metrics.api.jaxrs.param.DurationConverter;
import org.hawkular.metrics.api.jaxrs.param.PercentilesConverter;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.api.jaxrs.util.Logged;
import org.hawkular.metrics.api.jaxrs.util.MetricTypeTextConverter;
import org.hawkular.metrics.core.service.Functions;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.transformers.MinMaxTimestampTransformer;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.model.BucketPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.MixedMetricsRequest;
import org.hawkular.metrics.model.Percentile;
import org.hawkular.metrics.model.param.BucketConfig;
import org.hawkular.metrics.model.param.Duration;
import org.hawkular.metrics.model.param.Tags;
import org.hawkular.metrics.model.param.TimeRange;
import org.jboss.resteasy.annotations.GZIP;
import rx.Observable;
import rx.Observer;

@Path(value="/{dual_path:metrics|m}")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@GZIP
@Api(tags={"Metric"})
@ApplicationScoped
@Logged
public class MetricHandler {
    @Inject
    private MetricsService metricsService;
    @Context
    private HttpHeaders httpHeaders;

    private String getTenant() {
        return (String)this.httpHeaders.getRequestHeaders().getFirst((Object)"Hawkular-Tenant");
    }

    @POST
    @Path(value="/")
    @ApiOperation(value="Create metric.", notes="Clients are not required to explicitly create a metric before storing data. Doing so however allows clients to prevent naming collisions and to specify tags and data retention.")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric created successfully"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=409, message="Metric with given id already exists", response=ApiError.class), @ApiResponse(code=500, message="Metric creation failed due to an unexpected error", response=ApiError.class)})
    public <T> void createMetric(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true) Metric<T> metric, @ApiParam(value="Overwrite previously created metric if it exists. Defaults to false.", required=false) @DefaultValue(value="false") @QueryParam(value="overwrite") Boolean overwrite, @Context UriInfo uriInfo) {
        if (metric.getType() == null || !metric.getType().isUserType()) {
            asyncResponse.resume((Object)ApiUtils.badRequest(new ApiError("Metric type is invalid")));
        }
        MetricId id = new MetricId(this.getTenant(), metric.getMetricId().getType(), metric.getId());
        metric = new Metric(id, metric.getTags(), metric.getDataRetention());
        URI location = uriInfo.getBaseUriBuilder().path("/{type}/{id}").build(new Object[]{MetricTypeTextConverter.getLongForm(id.getType()), id.getName()});
        this.metricsService.createMetric(metric, overwrite.booleanValue()).subscribe((Observer)new MetricCreatedObserver(asyncResponse, location));
    }

    @GET
    @Path(value="/tags")
    @ApiOperation(value="Retrieve available tag names", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Tags successfully retrieved."), @ApiResponse(code=204, message="No tags were found"), @ApiResponse(code=500, message="Unexpected error occurred while fetching tags.", response=ApiError.class)})
    public <T> void getTagNames(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Tag name regexp filter") @QueryParam(value="filter") String tagNameFilter, @ApiParam(value="Tags applied to defined metric type", allowableValues="gauge, availability, counter, string") @QueryParam(value="type") MetricType<T> metricType) {
        this.metricsService.getTagNames(this.getTenant(), metricType, tagNameFilter).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError(t)));
    }

    @GET
    @Path(value="/tags/{tags}")
    @ApiOperation(value="Retrieve metrics' tag values", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Tags successfully retrieved."), @ApiResponse(code=204, message="No matching tags were found"), @ApiResponse(code=500, message="Unexpected error occurred while fetching tags.", response=ApiError.class)})
    public <T> void getTags(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Queried metric type", allowableValues="gauge, availability, counter, string") @QueryParam(value="type") MetricType<T> metricType, @ApiParam(value="Tag query") @PathParam(value="tags") Tags tags) {
        this.metricsService.getTagValues(this.getTenant(), metricType, tags.getTags()).map(ApiUtils::mapToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError(t)));
    }

    @GET
    @Path(value="/")
    @ApiOperation(value="Find tenant's metric definitions.", notes="Does not include any metric values. ", response=Metric.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved at least one metric definition."), @ApiResponse(code=204, message="No metrics found."), @ApiResponse(code=400, message="Invalid type parameter type.", response=ApiError.class), @ApiResponse(code=500, message="Failed to retrieve metrics due to unexpected error.", response=ApiError.class)})
    public <T> void findMetrics(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Queried metric type", required=false, allowableValues="gauge, availability, counter, string") @QueryParam(value="type") MetricType<T> metricType, @ApiParam(value="Fetch min and max timestamps of available datapoints") @DefaultValue(value="false") @QueryParam(value="timestamps") Boolean fetchTimestamps, @ApiParam(value="List of tags filters", required=false) @QueryParam(value="tags") String tags, @ApiParam(value="Regexp to match metricId if tags filtering is used, otherwise exact matching", required=false) @QueryParam(value="id") String id) {
        Observable metricObservable;
        if (metricType != null && !metricType.isUserType()) {
            asyncResponse.resume((Object)ApiUtils.badRequest(new ApiError("Incorrect type param " + metricType.toString())));
            return;
        }
        if (tags != null) {
            metricObservable = this.metricsService.findMetricsWithFilters(this.getTenant(), metricType, tags);
            if (!Strings.isNullOrEmpty((String)id)) {
                metricObservable = metricObservable.filter(this.metricsService.idFilter(id));
            }
        } else if (!Strings.isNullOrEmpty((String)id)) {
            if (metricType == null) {
                asyncResponse.resume((Object)ApiUtils.badRequest(new ApiError("Exact id search requires type to be set")));
                return;
            }
            Object[] ids = id.split("\\|");
            metricObservable = Observable.from((Object[])ids).map(idPart -> new MetricId(this.getTenant(), metricType, idPart)).flatMap(mId -> this.metricsService.findMetric(mId));
        } else {
            metricObservable = this.metricsService.findMetrics(this.getTenant(), metricType);
        }
        if (fetchTimestamps.booleanValue()) {
            metricObservable = metricObservable.compose((Observable.Transformer)new MinMaxTimestampTransformer(this.metricsService));
        }
        metricObservable.toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> {
            if (t instanceof PatternSyntaxException) {
                asyncResponse.resume((Object)ApiUtils.badRequest(t));
            } else {
                asyncResponse.resume((Object)ApiUtils.serverError(t));
            }
        });
    }

    @Deprecated
    @POST
    @Path(value="/data")
    @ApiOperation(value="Deprecated. Please use /raw endpoint.")
    public void deprecatedAddMetricsData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of metrics", required=true) MixedMetricsRequest metricsRequest) {
        this.addMetricsData(asyncResponse, metricsRequest);
    }

    @POST
    @Path(value="/raw")
    @ApiOperation(value="Add data points for multiple metrics in a single call.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data points succeeded."), @ApiResponse(code=400, message="Missing or invalid payload.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addMetricsData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of metrics", required=true) MixedMetricsRequest metricsRequest) {
        if (metricsRequest.isEmpty()) {
            asyncResponse.resume((Object)ApiUtils.emptyPayload());
            return;
        }
        Observable gauges = Functions.metricToObservable((String)this.getTenant(), (List)metricsRequest.getGauges(), (MetricType)MetricType.GAUGE);
        Observable availabilities = Functions.metricToObservable((String)this.getTenant(), (List)metricsRequest.getAvailabilities(), (MetricType)MetricType.AVAILABILITY);
        Observable counters = Functions.metricToObservable((String)this.getTenant(), (List)metricsRequest.getCounters(), (MetricType)MetricType.COUNTER);
        Observable strings = Functions.metricToObservable((String)this.getTenant(), (List)metricsRequest.getStrings(), (MetricType)MetricType.STRING);
        this.metricsService.addDataPoints(MetricType.GAUGE, gauges).mergeWith(this.metricsService.addDataPoints(MetricType.AVAILABILITY, availabilities)).mergeWith(this.metricsService.addDataPoints(MetricType.COUNTER, counters)).mergeWith(this.metricsService.addDataPoints(MetricType.STRING, strings)).subscribe(aVoid -> {}, t -> asyncResponse.resume((Object)ApiUtils.serverError(t)), () -> asyncResponse.resume((Object)Response.ok().build()));
    }

    @POST
    @Path(value="/stats/query")
    public void findStats(@Suspended AsyncResponse asyncResponse, StatsQueryRequest query) {
        try {
            this.checkRequiredParams(query);
            this.doStatsQuery(query).map(ApiUtils::mapToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.error(t)));
        }
        catch (IllegalArgumentException e) {
            asyncResponse.resume((Object)ApiUtils.badRequest(new ApiError(e.getMessage())));
        }
    }

    @POST
    @Path(value="/stats/batch/query")
    public void findStatsBatched(@Suspended AsyncResponse asyncResponse, Map<String, StatsQueryRequest> queries) {
        try {
            queries.values().forEach(this::checkRequiredParams);
            HashMap results = new HashMap();
            queries.entrySet().forEach(entry -> results.put(entry.getKey(), this.doStatsQuery((StatsQueryRequest)entry.getValue())));
            Observable.from(results.entrySet()).flatMap(entry -> ((Observable)entry.getValue()).map(map -> ImmutableMap.of(entry.getKey(), (Object)map))).collect(HashMap::new, HashMap::putAll).map(ApiUtils::mapToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.error(t)));
        }
        catch (IllegalArgumentException e) {
            asyncResponse.resume((Object)ApiUtils.badRequest(new ApiError(e.getMessage())));
        }
    }

    private Observable<Map<String, Map<String, List<? extends BucketPoint>>>> doStatsQuery(StatsQueryRequest query) {
        Duration duration = query.getBucketDuration() == null ? null : new DurationConverter().fromString(query.getBucketDuration());
        TimeRange timeRange = new TimeRange(query.getStart(), query.getEnd());
        BucketConfig bucketsConfig = new BucketConfig(query.getBuckets(), duration, timeRange);
        List percentiles = query.getPercentiles() == null ? Collections.emptyList() : new PercentilesConverter().fromString(query.getPercentiles()).getPercentiles();
        List types = Collections.emptyList();
        if (query.getTypes() != null) {
            types = query.getTypes().stream().map(MetricType::fromTextCode).collect(Collectors.toList());
        }
        Observable gaugeStats = Observable.just(Collections.emptyMap());
        Observable counterStats = Observable.just(Collections.emptyMap());
        Observable<Map<String, List<? extends BucketPoint>>> availabilityStats = Observable.just(Collections.emptyMap());
        Observable<Map<String, List<BucketPoint>>> gaugeRateStats = Observable.just(Collections.emptyMap());
        Observable<Map<String, List<BucketPoint>>> counterRateStats = Observable.just(Collections.emptyMap());
        if (!query.getMetrics().isEmpty() && (query.getMetrics().containsKey(MetricType.GAUGE.getText()) || query.getMetrics().containsKey(MetricType.COUNTER.getText()) || query.getMetrics().containsKey(MetricType.AVAILABILITY.getText()))) {
            if (!this.isMetricsEmpty(query, MetricType.GAUGE)) {
                if (types.isEmpty()) {
                    gaugeStats = this.getGaugeStats(this.getMetricIds(query, MetricType.GAUGE), bucketsConfig, (List<Percentile>)percentiles);
                } else if (types.contains(MetricType.GAUGE_RATE)) {
                    if (types.contains(MetricType.GAUGE)) {
                        gaugeStats = this.getGaugeStats(query, bucketsConfig, (List<Percentile>)percentiles);
                        gaugeRateStats = this.getRateStats(this.getMetricIds(query, MetricType.GAUGE), bucketsConfig, percentiles);
                    } else {
                        gaugeRateStats = this.getRateStats(this.getMetricIds(query, MetricType.GAUGE), bucketsConfig, percentiles);
                    }
                } else {
                    gaugeStats = this.getGaugeStats(this.getMetricIds(query, MetricType.GAUGE), bucketsConfig, (List<Percentile>)percentiles);
                }
            }
            if (!this.isMetricsEmpty(query, MetricType.COUNTER)) {
                if (types.isEmpty()) {
                    counterStats = this.getCounterStats(this.getMetricIds(query, MetricType.COUNTER), bucketsConfig, (List<Percentile>)percentiles);
                } else if (types.contains(MetricType.COUNTER_RATE)) {
                    if (types.contains(MetricType.COUNTER)) {
                        counterStats = this.getCounterStats(this.getMetricIds(query, MetricType.COUNTER), bucketsConfig, (List<Percentile>)percentiles);
                        counterRateStats = this.getRateStats(this.getMetricIds(query, MetricType.COUNTER), bucketsConfig, percentiles);
                    } else {
                        counterRateStats = this.getRateStats(this.getMetricIds(query, MetricType.COUNTER), bucketsConfig, percentiles);
                    }
                } else {
                    counterStats = this.getCounterStats(query, bucketsConfig, (List<Percentile>)percentiles);
                }
            }
            if (!this.isMetricsEmpty(query, MetricType.AVAILABILITY)) {
                availabilityStats = Observable.from((Iterable)query.getMetrics().get("availability")).flatMap(id -> this.metricsService.findAvailabilityStats(new MetricId(this.getTenant(), MetricType.AVAILABILITY, id), timeRange.getStart(), timeRange.getEnd(), bucketsConfig.getBuckets()).map(bucketPoints -> new NamedBucketPoints((String)id, bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
            }
        } else if (types.isEmpty()) {
            gaugeStats = this.getGaugeStatsFromTags(bucketsConfig, percentiles, query.getTags());
            counterStats = this.getCounterStatsFromTags(bucketsConfig, percentiles, query.getTags());
            availabilityStats = this.getAvailabilityStatsFromTags(bucketsConfig, query.getTags());
        } else {
            Observable ids;
            if (types.contains(MetricType.GAUGE) && types.contains(MetricType.GAUGE_RATE)) {
                Observable gauges = this.metricsService.findMetricsWithFilters(this.getTenant(), MetricType.GAUGE, query.getTags()).cache();
                gaugeStats = gauges.flatMap(gauge -> this.metricsService.findGaugeStats(gauge.getMetricId(), bucketsConfig, percentiles).map(bucketPoints -> new NamedBucketPoints(gauge.getMetricId().getName(), bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
                ids = gauges.map(Metric::getMetricId);
                gaugeRateStats = this.getRateStats(ids, bucketsConfig, percentiles);
            } else if (types.contains(MetricType.GAUGE)) {
                gaugeStats = this.getGaugeStatsFromTags(bucketsConfig, percentiles, query.getTags());
            } else {
                Observable gauges = this.metricsService.findMetricsWithFilters(this.getTenant(), MetricType.GAUGE, query.getTags());
                ids = gauges.map(Metric::getMetricId);
                gaugeRateStats = this.getRateStats(ids, bucketsConfig, percentiles);
            }
            if (types.contains(MetricType.COUNTER) && types.contains(MetricType.COUNTER_RATE)) {
                Observable counters = this.metricsService.findMetricsWithFilters(this.getTenant(), MetricType.COUNTER, query.getTags()).cache();
                counterStats = counters.flatMap(counter -> this.metricsService.findCounterStats(counter.getMetricId(), bucketsConfig, percentiles).map(bucketPoints -> new NamedBucketPoints(counter.getMetricId().getName(), bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
                ids = counters.map(Metric::getMetricId);
                counterRateStats = this.getRateStats(ids, bucketsConfig, percentiles);
            } else if (types.contains(MetricType.COUNTER)) {
                counterStats = this.getCounterStatsFromTags(bucketsConfig, percentiles, query.getTags());
            } else {
                Observable counters = this.metricsService.findMetricsWithFilters(this.getTenant(), MetricType.COUNTER, query.getTags());
                ids = counters.map(Metric::getMetricId);
                counterRateStats = this.getRateStats(ids, bucketsConfig, percentiles);
            }
            if (types.contains(MetricType.AVAILABILITY)) {
                availabilityStats = this.getAvailabilityStatsFromTags(bucketsConfig, query.getTags());
            }
        }
        return Observable.zip(gaugeStats, counterStats, availabilityStats, (Observable)gaugeRateStats, (Observable)counterRateStats, (gaugeMap, counterMap, availabiltyMap, gaugeRateMap, counterRateMap) -> {
            HashMap<String, Map> stats = new HashMap<String, Map>();
            if (!gaugeMap.isEmpty()) {
                stats.put(MetricType.GAUGE.getText(), (Map)gaugeMap);
            }
            if (!counterMap.isEmpty()) {
                stats.put(MetricType.COUNTER.getText(), (Map)counterMap);
            }
            if (!availabiltyMap.isEmpty()) {
                stats.put(MetricType.AVAILABILITY.getText(), (Map)availabiltyMap);
            }
            if (!gaugeRateMap.isEmpty()) {
                stats.put(MetricType.GAUGE_RATE.getText(), (Map)gaugeRateMap);
            }
            if (!counterRateMap.isEmpty()) {
                stats.put(MetricType.COUNTER_RATE.getText(), (Map)counterRateMap);
            }
            return stats;
        }).first();
    }

    private void checkRequiredParams(StatsQueryRequest query) {
        if (this.isMetricIdsEmpty(query) && query.getTags() == null) {
            throw new IllegalArgumentException("Either the metrics or the tags property must be set");
        }
        if (query.getBuckets() == null && query.getBucketDuration() == null) {
            throw new IllegalArgumentException("Either the buckets or bucketDuration property must be set");
        }
    }

    private Observable<Map<String, List<? extends BucketPoint>>> getCounterStatsFromTags(BucketConfig bucketsConfig, List<Percentile> percentiles, String tags) {
        Observable counters = this.metricsService.findMetricsWithFilters(this.getTenant(), MetricType.COUNTER, tags);
        return counters.flatMap(counter -> this.metricsService.findCounterStats(counter.getMetricId(), bucketsConfig, percentiles).map(bucketPoints -> new NamedBucketPoints(counter.getMetricId().getName(), bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
    }

    private Observable<Map<String, List<? extends BucketPoint>>> getGaugeStatsFromTags(BucketConfig bucketsConfig, List<Percentile> percentiles, String tags) {
        Observable gauges = this.metricsService.findMetricsWithFilters(this.getTenant(), MetricType.GAUGE, tags);
        return gauges.flatMap(gauge -> this.metricsService.findGaugeStats(gauge.getMetricId(), bucketsConfig, percentiles).map(bucketPoints -> new NamedBucketPoints(gauge.getMetricId().getName(), bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
    }

    private Observable<Map<String, List<? extends BucketPoint>>> getAvailabilityStatsFromTags(BucketConfig bucketsConfig, String tags) {
        Observable availabilities = this.metricsService.findMetricsWithFilters(this.getTenant(), MetricType.AVAILABILITY, tags);
        Observable availabilityStats = availabilities.flatMap(availability -> this.metricsService.findAvailabilityStats(availability.getMetricId(), bucketsConfig.getTimeRange().getStart(), bucketsConfig.getTimeRange().getEnd(), bucketsConfig.getBuckets()).map(bucketPoints -> new NamedBucketPoints(availability.getMetricId().getName(), bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
        return availabilityStats;
    }

    private Observable<Map<String, List<? extends BucketPoint>>> getGaugeStats(StatsQueryRequest query, BucketConfig bucketsConfig, List<Percentile> percentiles) {
        Observable gaugeStats = Observable.from((Iterable)query.getMetrics().get("gauge")).flatMap(id -> this.metricsService.findGaugeStats(new MetricId(this.getTenant(), MetricType.GAUGE, id), bucketsConfig, percentiles).map(bucketPoints -> new NamedBucketPoints((String)id, bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
        return gaugeStats;
    }

    private Observable<Map<String, List<? extends BucketPoint>>> getGaugeStats(Observable<MetricId<Double>> ids, BucketConfig bucketConfig, List<Percentile> percentiles) {
        return ids.flatMap(id -> this.metricsService.findGaugeStats(id, bucketConfig, percentiles).map(bucketPoints -> new NamedBucketPoints(id.getName(), bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
    }

    private Observable<Map<String, List<? extends BucketPoint>>> getCounterStats(Observable<MetricId<Long>> ids, BucketConfig bucketConfig, List<Percentile> percentiles) {
        return ids.flatMap(id -> this.metricsService.findCounterStats(id, bucketConfig, percentiles).map(bucketPoints -> new NamedBucketPoints(id.getName(), bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
    }

    private Observable<Map<String, List<? extends BucketPoint>>> getCounterStats(StatsQueryRequest query, BucketConfig bucketsConfig, List<Percentile> percentiles) {
        Observable counterStats = Observable.from((Iterable)query.getMetrics().get("counter")).flatMap(id -> this.metricsService.findCounterStats(new MetricId(this.getTenant(), MetricType.COUNTER, id), bucketsConfig, percentiles).map(bucketPoints -> new NamedBucketPoints((String)id, bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
        return counterStats;
    }

    private <T> Observable<MetricId<T>> getMetricIds(StatsQueryRequest query, MetricType<T> type) {
        return Observable.from((Iterable)query.getMetrics().get(type.getText())).map(id -> new MetricId(this.getTenant(), type, id));
    }

    private <T extends Number> Observable<Map<String, List<? extends BucketPoint>>> getRateStats(Observable<MetricId<T>> ids, BucketConfig bucketConfig, List<Percentile> percentiles) {
        return ids.flatMap(id -> this.metricsService.findRateStats(id, bucketConfig, percentiles).map(bucketPoints -> new NamedBucketPoints(id.getName(), bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
    }

    private <T> boolean isMetricsEmpty(StatsQueryRequest query, MetricType<T> type) {
        return query.getMetrics().get(type.getText()) == null || query.getMetrics().get(type.getText()).isEmpty();
    }

    private boolean isMetricIdsEmpty(StatsQueryRequest query) {
        if (query.getMetrics().isEmpty()) {
            return true;
        }
        return query.getMetrics().getOrDefault("gauge", Collections.emptyList()).isEmpty() && query.getMetrics().getOrDefault("counter", Collections.emptyList()).isEmpty() && query.getMetrics().getOrDefault("availability", Collections.emptyList()).isEmpty();
    }

    private class NamedBucketPoints<T extends BucketPoint> {
        public String id;
        public List<T> bucketPoints;

        public NamedBucketPoints(String id, List<T> bucketPoints) {
            this.id = id;
            this.bucketPoints = bucketPoints;
        }
    }
}

