/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.dropwizard;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.hawkular.metrics.api.jaxrs.dropwizard.HTTPMethod;
import org.hawkular.metrics.api.jaxrs.dropwizard.RESTMetricName;
import org.hawkular.metrics.core.dropwizard.MetaData;

public class RESTMetaData
extends MetaData {
    private static final String SCOPE = "REST";
    private RESTMetricName restMetricName;
    private Type type;

    public static RESTMetaData forRead(HTTPMethod method, String uri, String hostname) {
        return new RESTMetaData(new RESTMetricName(method, uri), Type.READ, hostname);
    }

    public static RESTMetaData forWrite(HTTPMethod method, String uri, String hostname) {
        return new RESTMetaData(new RESTMetricName(method, uri), Type.WRITE, hostname);
    }

    private RESTMetaData(RESTMetricName name, Type type, String hostname) {
        super(name.getName(), SCOPE, type.toString(), hostname, (Map)ImmutableMap.of((Object)"method", (Object)name.getMethod().toString(), (Object)"uri", (Object)name.getUri()));
        this.restMetricName = name;
        this.type = type;
    }

    public RESTMetricName getRESTMetricName() {
        return this.restMetricName;
    }

    public Type getRequestType() {
        return this.type;
    }

    public static enum Type {
        READ("read"),
        WRITE("write");

        private String text;

        private Type(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

