/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler.observer;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.NamedDataPoint;
import org.jboss.logging.Logger;
import rx.Subscriber;

public class NamedDataPointObserver<T>
extends Subscriber<NamedDataPoint<T>> {
    private static final Logger log = Logger.getLogger(NamedDataPointObserver.class);
    private final AsyncResponse response;
    private final JsonGenerator generator;
    private final WriteValue<T> writeValue;
    private final ByteArrayOutputStream jsonOutputStream;
    private volatile String currentMetric;

    public NamedDataPointObserver(AsyncResponse response, ObjectMapper mapper, MetricType<T> type) {
        this.response = response;
        this.jsonOutputStream = new ByteArrayOutputStream();
        try {
            this.generator = mapper.getFactory().createGenerator((OutputStream)this.jsonOutputStream, JsonEncoding.UTF8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (type == MetricType.GAUGE || type == MetricType.GAUGE_RATE || type == MetricType.COUNTER_RATE) {
            this.writeValue = dataPoint -> this.generator.writeNumberField("value", ((Double)dataPoint.getValue()).doubleValue());
        } else if (type == MetricType.COUNTER) {
            this.writeValue = dataPoint -> this.generator.writeNumberField("value", ((Long)dataPoint.getValue()).longValue());
        } else if (type == MetricType.AVAILABILITY) {
            this.writeValue = dataPoint -> {
                AvailabilityType availability = (AvailabilityType)dataPoint.getValue();
                this.generator.writeStringField("value", availability.getText());
            };
        } else if (type == MetricType.STRING) {
            this.writeValue = dataPoint -> this.generator.writeStringField("value", (String)dataPoint.getValue());
        } else {
            throw new IllegalArgumentException(type + " is not supported metric type. This class should be updated to add support for it!");
        }
    }

    public void onNext(NamedDataPoint<T> dataPoint) {
        try {
            if (this.currentMetric == null) {
                this.generator.writeStartArray();
                this.generator.writeStartObject();
                this.generator.writeStringField("id", dataPoint.getName());
                this.generator.writeArrayFieldStart("data");
                this.generator.writeStartObject();
                this.generator.writeNumberField("timestamp", dataPoint.getTimestamp());
                this.writeValue.call(dataPoint);
                if (!dataPoint.getTags().isEmpty()) {
                    this.writeTags(dataPoint.getTags());
                }
                this.generator.writeEndObject();
            } else if (this.currentMetric.equals(dataPoint.getName())) {
                this.generator.writeStartObject();
                this.generator.writeNumberField("timestamp", dataPoint.getTimestamp());
                this.writeValue.call(dataPoint);
                if (!dataPoint.getTags().isEmpty()) {
                    this.writeTags(dataPoint.getTags());
                }
                this.generator.writeEndObject();
            } else {
                this.generator.writeEndArray();
                this.generator.writeEndObject();
                this.generator.writeStartObject();
                this.generator.writeStringField("id", dataPoint.getName());
                this.generator.writeArrayFieldStart("data");
                this.generator.writeStartObject();
                this.generator.writeNumberField("timestamp", dataPoint.getTimestamp());
                this.writeValue.call(dataPoint);
                if (!dataPoint.getTags().isEmpty()) {
                    this.writeTags(dataPoint.getTags());
                }
                this.generator.writeEndObject();
            }
            this.currentMetric = dataPoint.getName();
        }
        catch (IOException e) {
            throw new RuntimeException("Streaming data to client failed", e);
        }
    }

    private void writeTags(Map<String, String> tags) throws IOException {
        this.generator.writeObjectFieldStart("tags");
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            this.generator.writeStringField(tag.getKey(), tag.getValue());
        }
        this.generator.writeEndObject();
    }

    public void onError(Throwable e) {
        log.trace((Object)"Fetching data failed", e);
        try {
            if (this.currentMetric == null) {
                this.response.resume((Object)ApiUtils.serverError(e));
            } else {
                this.generator.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void onCompleted() {
        Response result = null;
        try {
            if (this.currentMetric == null) {
                this.generator.close();
                result = Response.ok().status(204).build();
            } else {
                this.generator.writeEndArray();
                this.generator.writeEndObject();
                this.generator.writeEndArray();
                this.generator.close();
                result = Response.ok((Object)new String(this.jsonOutputStream.toByteArray()), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
            }
        }
        catch (IOException e) {
            result = ApiUtils.serverError(e);
            log.trace((Object)"Error while finishing streaming data", (Throwable)e);
        }
        finally {
            if (result == null) {
                result = Response.serverError().build();
            }
            this.response.resume((Object)result);
        }
    }

    @FunctionalInterface
    private static interface WriteValue<T> {
        public void call(NamedDataPoint<T> var1) throws IOException;
    }
}

