/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.util;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletContext;

@ApplicationScoped
public class ManifestInformation {
    private static final List<String> VERSION_ATTRIBUTES = ImmutableList.of((Object)"Implementation-Version", (Object)"Built-From-Git-SHA1");
    @Inject
    private ServletContext servletContext;
    private Map<String, String> attributes = new HashMap<String, String>();

    @PostConstruct
    public void init() {
        try (InputStream inputStream = this.servletContext.getResourceAsStream("/META-INF/MANIFEST.MF");){
            Manifest manifest = new Manifest(inputStream);
            Attributes attr = manifest.getMainAttributes();
            for (String attribute : VERSION_ATTRIBUTES) {
                this.attributes.put(attribute, attr.getValue(attribute));
            }
        }
        catch (Exception e) {
            for (String attribute : VERSION_ATTRIBUTES) {
                if (this.attributes.get(attribute) != null) continue;
                this.attributes.put(attribute, "Unknown");
            }
        }
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

