/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.param;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.param.TimeRange;
import rx.Observable;
import rx.functions.Func4;

public class TimeAndSortParams {
    private final TimeRange timeRange;
    private final int limit;
    private final Order order;

    private TimeAndSortParams(TimeRange timeRange, int limit, Order order) {
        this.timeRange = timeRange;
        this.limit = limit;
        this.order = order;
    }

    public static <T> DeferredBuilder<T> deferredBuilder(String start, String end) {
        return new DeferredBuilder(start, end);
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    public int getLimit() {
        return this.limit;
    }

    public Order getOrder() {
        return this.order;
    }

    public static class DeferredBuilder<T> {
        private final String start;
        private final String end;
        private Boolean fromEarliest;
        private List<MetricId<T>> metricIds;
        private Order order;
        private int limit;
        private boolean forString = false;
        private Func4<String, String, Boolean, Collection<MetricId<T>>, Observable<TimeRange>> findTimeRange;

        private DeferredBuilder(String start, String end) {
            this.start = start;
            this.end = end;
        }

        public DeferredBuilder<T> fromEarliest(Boolean fromEarliest, List<MetricId<T>> metricIds, Func4<String, String, Boolean, Collection<MetricId<T>>, Observable<TimeRange>> findTimeRange) {
            this.fromEarliest = fromEarliest;
            this.metricIds = metricIds;
            this.findTimeRange = findTimeRange;
            return this;
        }

        public DeferredBuilder<T> fromEarliest(Boolean fromEarliest, MetricId<T> metricId, Func4<String, String, Boolean, Collection<MetricId<T>>, Observable<TimeRange>> findTimeRange) {
            this.fromEarliest = fromEarliest;
            this.metricIds = Collections.singletonList(metricId);
            this.findTimeRange = findTimeRange;
            return this;
        }

        public DeferredBuilder<T> sortOptions(Integer limit, String order) {
            this.limit = limit == null ? 0 : limit;
            this.order = order == null ? null : Order.fromText((String)order);
            return this;
        }

        public DeferredBuilder<T> sortOptions(Integer limit, Order order) {
            this.limit = limit == null ? 0 : limit;
            this.order = order;
            return this;
        }

        public DeferredBuilder<T> forString() {
            this.forString = true;
            return this;
        }

        private Order getOrderForString() {
            if (this.order != null) {
                return this.order;
            }
            if (this.limit != 0 && this.start != null && this.end == null) {
                return Order.ASC;
            }
            return Order.DESC;
        }

        public Observable<TimeAndSortParams> toObservable() {
            Order fOrder = this.forString ? this.getOrderForString() : (this.order == null ? Order.defaultValue((int)this.limit, (Object)this.start, (Object)this.end) : this.order);
            return ((Observable)this.findTimeRange.call((Object)this.start, (Object)this.end, (Object)this.fromEarliest, this.metricIds)).map(tr -> new TimeAndSortParams((TimeRange)tr, this.limit, fOrder));
        }
    }
}

