/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler.observer;

import java.net.URI;
import java.util.function.Function;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import rx.Observer;

public abstract class EntityCreatedObserver<E>
implements Observer<Void> {
    private final AsyncResponse asyncResponse;
    private final URI location;
    private final Class<E> alreadyExistsException;
    private final Function<E, Response> alreadyExistsResponseBuilder;

    public EntityCreatedObserver(AsyncResponse asyncResponse, URI location, Class<E> alreadyExistsExceptionType, Function<E, Response> alreadyExistsResponseBuilder) {
        this.asyncResponse = asyncResponse;
        this.location = location;
        this.alreadyExistsException = alreadyExistsExceptionType;
        this.alreadyExistsResponseBuilder = alreadyExistsResponseBuilder;
    }

    public void onNext(Void aVoid) {
    }

    public void onError(Throwable t) {
        Response response = this.alreadyExistsException.isAssignableFrom(t.getClass()) ? (Response)this.alreadyExistsResponseBuilder.apply(this.alreadyExistsException.cast(t)) : ApiUtils.serverError((Throwable)t, (String)"Failed to create tenant due to an unexpected error");
        this.asyncResponse.resume((Object)response);
    }

    public void onCompleted() {
        this.asyncResponse.resume((Object)Response.created((URI)this.location).build());
    }
}

