/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.wordnik.swagger.annotations.ApiModel;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.hawkular.metrics.core.api.DataPoint;

@ApiModel(description="A timestamp and a value where the value is interpreted as a floating point number")
public class GaugeDataPoint {
    @JsonProperty
    private long timestamp;
    @JsonProperty
    private Double value;
    @JsonProperty
    private Map<String, String> tags = Collections.emptyMap();

    private GaugeDataPoint() {
    }

    public GaugeDataPoint(DataPoint<Double> dataPoint) {
        this.timestamp = dataPoint.getTimestamp();
        this.value = (Double)dataPoint.getValue();
        this.tags = dataPoint.getTags();
    }

    public Double getValue() {
        return this.value;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Map<String, String> getTags() {
        return ImmutableMap.copyOf((Map)this.tags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GaugeDataPoint that = (GaugeDataPoint)o;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.value);
    }

    public String toString() {
        return com.google.common.base.Objects.toStringHelper((String)"GaugeDataPoint").add("timestamp", this.timestamp).add("value", (Object)this.value).add("tags", (Object)this.tags).toString();
    }
}

