/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.servlet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hawkular.metrics.api.servlet.rx.ObservableServlet;
import org.hawkular.metrics.core.service.MetricsService;
import rx.Observable;
import rx.Observer;
import rx.exceptions.Exceptions;
import rx.subjects.PublishSubject;

@WebServlet(urlPatterns={"/openshift/*"}, asyncSupported=true)
public class OpenshiftServlet
extends HttpServlet {
    private static final ObjectMapper objectMapper;
    private static final ObjectWriter objectWriter;
    private static final byte[] comma;
    private static final String DESCRIPTOR_TAG = "descriptor_name";
    @Inject
    private MetricsService metricsService;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setCharacterEncoding("UTF-8");
        resp.setContentType("application/json");
        AsyncContext asyncContext = this.getAsyncContext(req);
        Observable metricObservable = this.metricsService.scanAllMetricIndexes().filter(m -> m.getTags().containsKey(DESCRIPTOR_TAG)).onBackpressureBuffer();
        final PublishSubject byteSubject = PublishSubject.create();
        Observable buffers = metricObservable.map(m -> {
            try {
                return objectWriter.writeValueAsBytes(m);
            }
            catch (JsonProcessingException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }).onBackpressureBuffer();
        buffers.subscribe((Observer)new Observer<byte[]>(){
            AtomicBoolean first = new AtomicBoolean(true);

            public void onCompleted() {
                if (!this.first.get()) {
                    byteSubject.onNext((Object)"]".getBytes(Charset.forName("UTF-8")));
                }
                byteSubject.onCompleted();
            }

            public void onError(Throwable throwable) {
            }

            public void onNext(byte[] bytes) {
                if (this.first.compareAndSet(true, false)) {
                    byteSubject.onNext((Object)"[".getBytes(Charset.forName("UTF-8")));
                    byteSubject.onNext((Object)bytes);
                } else {
                    byteSubject.onNext((Object)comma);
                    byteSubject.onNext((Object)bytes);
                }
            }
        });
        ObservableServlet.write((Observable<byte[]>)byteSubject, resp.getOutputStream()).subscribe(v -> {}, t -> {
            t.printStackTrace();
            asyncContext.complete();
        }, () -> ((AsyncContext)asyncContext).complete());
    }

    private AsyncContext getAsyncContext(HttpServletRequest req) {
        if (req.isAsyncStarted()) {
            return req.getAsyncContext();
        }
        return req.startAsync();
    }

    static {
        comma = ",".getBytes(Charset.forName("UTF-8"));
        objectMapper = new ObjectMapper();
        objectWriter = objectMapper.writer();
    }
}

