/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.log.time;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import org.hawkular.metrics.api.jaxrs.log.RestLogger;
import org.hawkular.metrics.api.jaxrs.log.RestLogging;

public class RequestTimeLogger
implements HttpHandler {
    private static final RestLogger log = RestLogging.getRestLogger(RequestTimeLogger.class);
    private static final String tenantHeader = "Hawkular-Tenant";
    private HttpHandler next;
    private long timeThreshold;

    public RequestTimeLogger(HttpHandler next, long timeThreshold) {
        this.next = next;
        this.timeThreshold = timeThreshold;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        TimeMeasurer timeMeasurer = new TimeMeasurer(this.timeThreshold);
        timeMeasurer.setStartTime(System.currentTimeMillis());
        exchange.addExchangeCompleteListener((ExchangeCompletionListener)timeMeasurer);
        this.next.handleRequest(exchange);
    }

    private class TimeMeasurer
    implements ExchangeCompletionListener {
        private long start;
        private long timeThreshold;

        TimeMeasurer(long timeThreshold) {
            this.timeThreshold = timeThreshold;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            try {
                long end = System.currentTimeMillis();
                long duration = end - this.start;
                if (duration > this.timeThreshold) {
                    String method = exchange.getRequestMethod().toString();
                    String query = exchange.getQueryString();
                    String request_url = exchange.getRequestURI() + (query.isEmpty() ? "" : "?" + query);
                    HeaderMap headers = exchange.getRequestHeaders();
                    if (headers.contains(RequestTimeLogger.tenantHeader)) {
                        String tenantId = headers.get(RequestTimeLogger.tenantHeader, 0);
                        log.warnf("Request %s %s took: %d ms, exceeds %d ms threshold, tenant-id: %s", new Object[]{method, request_url, duration, this.timeThreshold, tenantId});
                    } else {
                        log.warnf("Request %s %s took: %d ms, exceeds %d ms threshold, no tenant", new Object[]{method, request_url, duration, this.timeThreshold});
                    }
                }
            }
            finally {
                if (nextListener != null) {
                    nextListener.proceed();
                }
            }
        }

        void setStartTime(long start) {
            this.start = start;
        }
    }
}

