/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.hawkular.metrics.api.jaxrs.MetricsServiceLifecycle;
import org.hawkular.metrics.api.jaxrs.util.ManifestInformation;
import org.hawkular.metrics.model.CassandraStatus;
import org.jboss.resteasy.annotations.GZIP;

@Path(value="/status")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@GZIP
@ApplicationScoped
public class StatusHandler {
    public static final String PATH = "/status";
    private static final String METRICSSERVICE_NAME = "MetricsService";
    @Inject
    MetricsServiceLifecycle metricsServiceLifecycle;
    @Inject
    ManifestInformation manifestInformation;

    @GET
    @ApiOperation(value="Returns the current status for various components.", response=Map.class)
    public Response status() {
        HashMap<String, String> status = new HashMap<String, String>();
        MetricsServiceLifecycle.State metricState = this.metricsServiceLifecycle.getState();
        status.put(METRICSSERVICE_NAME, metricState.toString());
        status.putAll(this.manifestInformation.getAttributes());
        List<CassandraStatus> cassandraStatuses = this.metricsServiceLifecycle.getCassandraStatus();
        int nodesUp = 0;
        int nodesDown = 0;
        for (CassandraStatus cassandraStatus : cassandraStatuses) {
            if (cassandraStatus.getStatus().equals("up")) {
                ++nodesUp;
                continue;
            }
            ++nodesDown;
        }
        if (nodesUp == cassandraStatuses.size()) {
            status.put("Cassandra", "up");
        } else if (nodesDown == cassandraStatuses.size()) {
            status.put("Cassandra", "down");
        } else {
            status.put("Cassandra", "degraded");
        }
        return Response.ok(status).build();
    }
}

