/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.google.common.collect.ImmutableMap;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.handler.observer.TenantCreatedObserver;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.api.jaxrs.util.Logged;
import org.hawkular.metrics.core.jobs.JobsService;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.model.TenantDefinition;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.GZIP;
import rx.Observer;

@Path(value="/tenants")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@GZIP
@Api(tags={"Tenant"})
@ApplicationScoped
@Logged
public class TenantsHandler {
    private Logger logger = Logger.getLogger(TenantsHandler.class);
    @Inject
    private MetricsService metricsService;
    @Inject
    private JobsService jobsService;

    @Deprecated
    @POST
    @ApiOperation(value="Create a new tenant.", notes="Clients are not required to create explicitly create a tenant before starting to store metric data. It is recommended to do so however to ensure that there are no tenant id naming collisions and to provide default data retention settings.")
    @ApiResponses(value={@ApiResponse(code=201, message="Tenant has been succesfully created."), @ApiResponse(code=400, message="Missing or invalid retention properties. ", response=ApiError.class), @ApiResponse(code=409, message="Given tenant id has already been created.", response=ApiError.class), @ApiResponse(code=500, message="An unexpected error occured while trying to create a tenant.", response=ApiError.class)})
    public void createTenant(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true) TenantDefinition tenantDefinition, @ApiParam(value="Overwrite previously created tenant configuration if it exists. Only data retention settings are overwriten; existing metrics and data points are unnafected. Defaults to false.", required=false) @DefaultValue(value="false") @QueryParam(value="overwrite") Boolean overwrite, @Context UriInfo uriInfo) {
        this.logger.warn((Object)"The create tenant endpoint is deprecated");
        URI location = uriInfo.getBaseUriBuilder().path("/tenants").build(new Object[0]);
        this.metricsService.createTenant(tenantDefinition.toTenant(), overwrite.booleanValue()).subscribe((Observer)new TenantCreatedObserver(asyncResponse, location));
    }

    @Deprecated
    @GET
    @ApiOperation(value="Returns a list of tenants.", response=TenantDefinition.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Returned a list of tenants successfully."), @ApiResponse(code=204, message="No tenants were found."), @ApiResponse(code=500, message="Unexpected error occurred while fetching tenants.", response=ApiError.class)})
    public void findTenants(@Suspended AsyncResponse asyncResponse) {
        this.logger.warn((Object)"The findTenants endpoint is deprecated");
        this.metricsService.getTenants().map(TenantDefinition::new).toList().subscribe(tenants -> asyncResponse.resume((Object)ApiUtils.collectionToResponse(tenants)), error -> asyncResponse.resume((Object)ApiUtils.serverError(error)));
    }

    @Deprecated
    @DELETE
    @Path(value="/{id}")
    @ApiOperation(value="Asynchronously deletes a tenant. All metrics and their data points will be deleted. Internal indexes are also updated. A response is returned as soon as a job to delete the tenant gets created and scheduled. The response returns the id of the tenant deletion job.")
    @ApiResponses(value={@ApiResponse(code=200, message="Tenant deletion job gets scheduled. The job id is returned."), @ApiResponse(code=500, message="Unexpected error occurred trying to scheduled the tenant deletion job.")})
    public void deleteTenant(@Suspended AsyncResponse asyncResponse, @PathParam(value="id") String id) {
        this.logger.warn((Object)"The tenant deletion endpoint is deprecated");
        this.jobsService.submitDeleteTenantJob(id, "Delete" + id).subscribe(jobDetails -> asyncResponse.resume((Object)Response.ok((Object)ImmutableMap.of((Object)"jobId", (Object)jobDetails.getJobId().toString())).header("WARNING: 299", (Object)"Deprecated API").build()), t -> {
            this.logger.warn((Object)("Deleting tenant [" + id + "] failed"), t);
            asyncResponse.resume((Object)ApiUtils.badRequest(t));
        });
    }
}

