/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.hawkular.metrics.api.jaxrs.handler.observer.NamedDataPointObserver;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.exception.RuntimeApiError;
import org.hawkular.metrics.model.param.TimeRange;
import rx.Observable;

abstract class MetricsServiceHandler {
    @Inject
    protected MetricsService metricsService;
    @Inject
    protected ObjectMapper mapper;
    @Context
    protected HttpHeaders httpHeaders;

    MetricsServiceHandler() {
    }

    protected String getTenant() {
        return (String)this.httpHeaders.getRequestHeaders().getFirst((Object)"Hawkular-Tenant");
    }

    <T> NamedDataPointObserver<T> createNamedDataPointObserver(AsyncResponse response, MetricType<T> type) {
        return new NamedDataPointObserver<T>(response, this.mapper, type);
    }

    <T> Observable<MetricId<T>> findMetricsByNameOrTag(List<String> metricNames, String tags, MetricType<T> type) {
        if ((metricNames == null || metricNames.isEmpty()) && tags == null) {
            return Observable.error((Throwable)new RuntimeApiError("Either metrics or tags query parameters must be used"));
        }
        if (metricNames != null && !metricNames.isEmpty() && tags != null) {
            return Observable.error((Throwable)new RuntimeApiError("Cannot use both the metrics and tags query parameters"));
        }
        if (metricNames != null && !metricNames.isEmpty()) {
            return Observable.from(metricNames).map(id -> new MetricId(this.getTenant(), type, id));
        }
        return this.metricsService.findMetricIdentifiersWithFilters(this.getTenant(), type, tags);
    }

    <T> Observable<TimeRange> findTimeRange(String start, String end, Boolean fromEarliest, Collection<MetricId<T>> metricIds) {
        if (Boolean.TRUE.equals(fromEarliest)) {
            if (start != null || end != null) {
                return Observable.error((Throwable)new RuntimeApiError("fromEarliest can only be used without start & end"));
            }
            return Observable.from(metricIds).flatMap(arg_0 -> ((MetricsService)this.metricsService).findMetric(arg_0)).toList().map(metrics -> metrics.stream().map(Metric::getDataRetention).filter(r -> r != null).reduce(Math::max).map(maxRetention -> {
                long dataRetention = (long)(maxRetention * 24 * 60 * 60) * 1000L;
                long now = System.currentTimeMillis();
                long earliest = now - dataRetention;
                return new TimeRange(Long.valueOf(earliest), Long.valueOf(now));
            })).filter(Optional::isPresent).map(Optional::get);
        }
        TimeRange timeRange = new TimeRange(start, end);
        if (!timeRange.isValid()) {
            return Observable.error((Throwable)new RuntimeApiError(timeRange.getProblem()));
        }
        return Observable.just((Object)timeRange);
    }
}

