/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.log;

import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.util.HttpString;
import javax.servlet.ServletContext;
import org.hawkular.metrics.api.jaxrs.log.RestLogger;
import org.hawkular.metrics.api.jaxrs.log.RestLogging;

public class HttpErrorLoggerExtension
implements ServletExtension {
    private static final RestLogger log = RestLogging.getRestLogger(HttpErrorLoggerExtension.class);
    private HttpErrorHandler httpErrorHandler;

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContext servletContext) {
        deploymentInfo.addInitialHandlerChainWrapper(containerHandler -> {
            this.httpErrorHandler = new HttpErrorHandler(containerHandler);
            return this.httpErrorHandler;
        });
    }

    class HttpErrorHandler
    implements HttpHandler {
        private HttpHandler next;

        public HttpErrorHandler(HttpHandler next) {
            this.next = next;
        }

        public void handleRequest(HttpServerExchange exchange) throws Exception {
            exchange.addExchangeCompleteListener((ExchangeCompletionListener)new HttpErrorExchangeCompleteListener());
            this.next.handleRequest(exchange);
        }
    }

    class HttpErrorExchangeCompleteListener
    implements ExchangeCompletionListener {
        HttpErrorExchangeCompleteListener() {
        }

        public void exchangeEvent(HttpServerExchange exchange, ExchangeCompletionListener.NextListener nextListener) {
            int httpStatusCode = exchange.getStatusCode();
            if (httpStatusCode >= 400) {
                String query = exchange.getQueryString();
                String path = !query.isEmpty() ? exchange.getRequestPath() + "?" + query : exchange.getRequestPath();
                HttpString method = exchange.getRequestMethod();
                log.warnf("Endpoint %s %s fails with HTTP code: %d", method, path, httpStatusCode);
            }
            nextListener.proceed();
        }
    }
}

