/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.config;

import com.google.common.base.Preconditions;

public enum ConfigurationKey {
    ALLOWED_CORS_ORIGINS("hawkular.metrics.allowed-cors-origins", "*", "ALLOWED_CORS_ORIGINS", false),
    ALLOWED_CORS_ACCESS_CONTROL_ALLOW_HEADERS("hawkular.metrics.allowed-cors-access-control-allow-headers", null, " ALLOWED_CORS_ACCESS_CONTROL_ALLOW_HEADERS", false),
    CASSANDRA_NODES("hawkular.metrics.cassandra.nodes", "127.0.0.1", "CASSANDRA_NODES", false),
    CASSANDRA_CQL_PORT("hawkular.metrics.cassandra.cql-port", "9042", "CASSANDRA_CQL_PORT", false),
    CASSANDRA_KEYSPACE("hawkular.metrics.cassandra.keyspace", "hawkular_metrics", null, false),
    CASSANDRA_RESETDB("hawkular.metrics.cassandra.resetdb", null, null, true),
    CASSANDRA_USESSL("hawkular.metrics.cassandra.use-ssl", "false", "CASSANDRA_USESSL", false),
    CASSANDRA_MAX_CONN_HOST("hawkular.metrics.cassandra.max-connections-per-host", "10", "CASSANDRA_MAX_CONN_HOST", false),
    CASSANDRA_MAX_REQUEST_CONN("hawkular.metrics.cassandra.max-requests-per-connection", "5000", "CASSANDRA_MAX_REQUEST_CONN", false),
    CASSANDRA_REQUEST_TIMEOUT("hawkular.metrics.cassandra.request-timeout", "12000", "CASSANDRA_REQUEST_TIMEOUT", false),
    CASSANDRA_CONNECTION_TIMEOUT("hawkular.metrics.cassandra.connection-timeout", "5000", "CASSANDRA_CONNECTION_TIMEOUT", false),
    CASSANDRA_SCHEMA_REFRESH_INTERVAL("hawkular.metrics.cassandra.schema.refresh-interval", "1000", "CASSANDRA_SCHEMA_REFRESH_INTERVAL", false),
    WAIT_FOR_SERVICE("hawkular.metrics.waitForService", null, null, true),
    DEFAULT_TTL("hawkular.metrics.default-ttl", "7", "DEFAULT_TTL", false),
    DISABLE_METRICS_JMX("hawkular.metrics.disable-metrics-jmx-reporting", null, "DISABLE_METRICS_JMX", true),
    ADMIN_TOKEN("hawkular.metrics.admin-token", null, "ADMIN_TOKEN", false),
    INGEST_MAX_RETRIES("hawkular.metrics.ingestion.retry.max-retries", null, "INGEST_MAX_RETRIES", false),
    INGEST_MAX_RETRY_DELAY("hawkular.metrics.ingestion.retry.max-delay", null, "INGEST_MAX_RETRY_DELAY", false),
    METRICS_PUBLISH_PERIOD("hawkular.metrics.publish-period", "2000", "METRICS_PUBLISH_PERIOD", false),
    DISABLE_METRICS_FORWARDING("hawkular.metrics.disable-metrics-forwarding", null, "DISABLE_METRICS_FORWARDING", true),
    DISABLE_PUBLISH_FILTERING("hawkular.metrics.disable-publish-filtering", null, "DISABLE_PUBLISH_FILTERING", true);

    private final String name;
    private final String env;
    private final String defaultValue;
    private final boolean flag;

    private ConfigurationKey(String name, String defaultValue, String env, boolean flag) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"name is null");
        Preconditions.checkArgument((!flag || defaultValue == null ? 1 : 0) != 0, (Object)"Config flags can't have a default value");
        this.name = name;
        this.env = env;
        this.defaultValue = defaultValue;
        this.flag = flag;
    }

    public String toString() {
        return this.name;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String toEnvString() {
        return this.env;
    }

    public boolean isFlag() {
        return this.flag;
    }
}

