/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Resource;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.enterprise.context.Dependent;
import javax.jms.CompletionListener;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.hawkular.bus.common.BasicMessage;
import org.jboss.logging.Logger;
import rx.Observable;
import rx.Subscriber;

@Dependent
public class Bus {
    public static final String HEADER_BASIC_MESSAGE_CLASS = "basicMessageClassName";
    private static final Logger log = Logger.getLogger(Bus.class);
    @Resource(name="java:/HawkularBusConnectionFactory")
    private ConnectionFactory connectionFactory;
    @Resource
    private ManagedExecutorService executorService;

    public <T extends BasicMessage> Observable<TextMessage> send(Destination destination, T message) {
        return Observable.create(subscriber -> {
            try {
                JMSContext context = this.connectionFactory.createContext();
                try {
                    JMSProducer producer = context.createProducer();
                    TextMessage jmsMessage = context.createTextMessage();
                    this.prepareJMSMessage(message, jmsMessage, Collections.emptyMap());
                    producer.setAsync(new CompletionListener((Subscriber)subscriber, context){
                        final /* synthetic */ Subscriber val$subscriber;
                        final /* synthetic */ JMSContext val$context;
                        {
                            this.val$subscriber = subscriber;
                            this.val$context = jMSContext;
                        }

                        public void onCompletion(Message message) {
                            this.val$subscriber.onNext((Object)((TextMessage)message));
                            Bus.this.close((AutoCloseable)this.val$context);
                            this.val$subscriber.onCompleted();
                        }

                        public void onException(Message message, Exception exception) {
                            Bus.this.close((AutoCloseable)this.val$context);
                            this.val$subscriber.onError((Throwable)exception);
                        }
                    });
                    producer.send(destination, (Message)jmsMessage);
                }
                catch (Exception e) {
                    this.close((AutoCloseable)context);
                    subscriber.onError((Throwable)e);
                }
            }
            catch (Exception e) {
                subscriber.onError((Throwable)e);
            }
        });
    }

    private <T extends BasicMessage> Message prepareJMSMessage(T message, TextMessage jmsMessage, Map<String, String> headers) throws JMSException {
        String json = message.toJSON();
        jmsMessage.setText(json);
        this.setHeaders((Message)jmsMessage, message, headers);
        if (message.getCorrelationId() != null) {
            jmsMessage.setJMSCorrelationID(message.getCorrelationId().getId());
        }
        return jmsMessage;
    }

    private <T extends BasicMessage> void setHeaders(Message message, T basicMessage, Map<String, String> headers) throws JMSException {
        message.setStringProperty(HEADER_BASIC_MESSAGE_CLASS, basicMessage.getClass().getName());
        basicMessage.getHeaders().entrySet().stream().forEach(entry -> {
            try {
                message.setStringProperty((String)entry.getKey(), (String)entry.getValue());
            }
            catch (JMSException e) {
                throw new RuntimeException("Failed to set header {key: " + (String)entry.getKey() + ", value: " + (String)entry.getValue() + "}", e);
            }
        });
        headers.entrySet().stream().forEach(entry -> {
            try {
                message.setStringProperty((String)entry.getKey(), (String)entry.getValue());
            }
            catch (JMSException e) {
                throw new RuntimeException("Failed to set header {key: " + (String)entry.getKey() + ", value: " + (String)entry.getValue() + "}", e);
            }
        });
    }

    private void close(AutoCloseable closeable) {
        this.executorService.submit(() -> {
            try {
                log.debug((Object)("Closing " + closeable));
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Exception e) {
                log.warn((Object)("Failed to close " + closeable), (Throwable)e);
            }
        });
    }
}

