/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.component.publish;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.enterprise.context.ApplicationScoped;
import org.hawkular.metrics.api.jaxrs.util.Eager;
import org.hawkular.metrics.model.MetricId;
import org.infinispan.Cache;
import org.jboss.logging.Logger;

@ApplicationScoped
@Eager
public class PublishCommandTable {
    private static final Logger LOG = Logger.getLogger(PublishCommandTable.class);
    @Resource(lookup="java:jboss/infinispan/cache/hawkular-metrics/publish")
    private Cache publishCache;

    public boolean isPublished(MetricId id) {
        if (id == null) {
            return false;
        }
        boolean isPublished = this.publishCache.containsKey((Object)this.convert(id));
        LOG.debugf("isPublished( %s ) = %s Publish Cache size: %s", (Object)id, (Object)isPublished, (Object)this.publishCache.size());
        return isPublished;
    }

    public synchronized void add(List<MetricId> ids) {
        if (ids != null) {
            this.publishCache.putAll(ids.stream().collect(Collectors.toMap(id -> this.convert((MetricId)id), id -> this.convert((MetricId)id))));
        }
    }

    private String convert(MetricId id) {
        return (id.getTenantId() == null ? "" : id.getTenantId()) + "-" + (id.getType() == null ? "" : id.getType().getText()) + "-" + (id.getName() == null ? "" : id.getName());
    }
}

