/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.component.publish;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.hawkular.bus.common.AbstractMessage;

public class MetricDataMessage
extends AbstractMessage {
    @JsonInclude
    private MetricData metricData;

    protected MetricDataMessage() {
    }

    public MetricDataMessage(MetricData metricData) {
        this.metricData = metricData;
    }

    public MetricData getMetricData() {
        return this.metricData;
    }

    public void setMetricData(MetricData metricData) {
        this.metricData = metricData;
    }

    public String toString() {
        return "MetricDataMessage{metricData=" + this.metricData + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MetricDataMessage that = (MetricDataMessage)((Object)o);
        return Objects.equals(this.metricData, that.metricData);
    }

    public int hashCode() {
        return Objects.hash(this.metricData);
    }

    public static class SingleMetric {
        @JsonInclude
        private String type;
        @JsonInclude
        private String source;
        @JsonInclude
        private long timestamp;
        @JsonInclude
        private double value;

        public SingleMetric() {
        }

        public SingleMetric(String type, String source, long timestamp, double value) {
            this.type = type;
            this.source = source;
            this.timestamp = timestamp;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleMetric that = (SingleMetric)o;
            if (this.timestamp != that.timestamp) {
                return false;
            }
            if (Double.compare(that.value, this.value) != 0) {
                return false;
            }
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
                return false;
            }
            return this.source != null ? this.source.equals(that.source) : that.source == null;
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
            result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
            long temp = Double.doubleToLongBits(this.value);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public String toString() {
            return "SingleMetric{type='" + this.type + '\'' + ", source='" + this.source + '\'' + ", timestamp=" + this.timestamp + ", value=" + this.value + '}';
        }
    }

    public static class MetricData {
        @JsonInclude
        String tenantId;
        @JsonInclude
        List<SingleMetric> data;

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public List<SingleMetric> getData() {
            return this.data;
        }

        public void setData(List<SingleMetric> data) {
            this.data = data;
        }

        public String toString() {
            return "MetricData [tenantId=" + this.tenantId + ", data=" + this.data + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricData that = (MetricData)o;
            return Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.data, that.data);
        }

        public int hashCode() {
            return Objects.hash(this.tenantId, this.data);
        }
    }
}

