/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.security;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Deque;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InfluxAuthHttpHandler
implements HttpHandler {
    private static final Pattern INFLUX_URI_PATTERN = Pattern.compile("^/hawkular/metrics/db/(.+)/series$");
    private static final HttpString PERSONA_HEADER = HttpString.tryFromString((String)"Hawkular-Persona");
    private static final String USERNAME_PARAM_NAME = "u";
    private static final String PASSWORD_PARAM_NAME = "p";
    private HttpHandler next;

    public InfluxAuthHttpHandler(HttpHandler next) {
        this.next = next;
    }

    public void handleRequest(HttpServerExchange httpServerExchange) throws Exception {
        if (httpServerExchange.isInIoThread()) {
            httpServerExchange.dispatch((HttpHandler)this);
            return;
        }
        Matcher matcher = INFLUX_URI_PATTERN.matcher(httpServerExchange.getRequestURI());
        if (!matcher.matches()) {
            this.next.handleRequest(httpServerExchange);
            return;
        }
        HeaderMap requestHeaders = httpServerExchange.getRequestHeaders();
        String databaseName = matcher.group(1);
        try {
            UUID.fromString(databaseName);
        }
        catch (IllegalArgumentException e) {
            httpServerExchange.setStatusCode(400);
            httpServerExchange.getResponseHeaders().put(Headers.CONTENT_TYPE, "text/plain");
            httpServerExchange.getResponseSender().send("Database name is not a valid identifier.", StandardCharsets.UTF_8);
            return;
        }
        requestHeaders.put(PERSONA_HEADER, databaseName);
        Map requestParameters = httpServerExchange.getQueryParameters();
        Deque usernameParamValues = (Deque)requestParameters.get(USERNAME_PARAM_NAME);
        Deque passwordParamValues = (Deque)requestParameters.get(PASSWORD_PARAM_NAME);
        if (usernameParamValues != null && passwordParamValues != null) {
            String concat = (String)usernameParamValues.getFirst() + ":" + (String)passwordParamValues.getFirst();
            String encoded = Base64.getEncoder().encodeToString(concat.getBytes(StandardCharsets.UTF_8));
            String authHeader = "Basic " + encoded;
            requestHeaders.put(Headers.AUTHORIZATION, authHeader);
            httpServerExchange.getQueryParameters().remove(USERNAME_PARAM_NAME);
            httpServerExchange.getQueryParameters().remove(PASSWORD_PARAM_NAME);
        }
        this.next.handleRequest(httpServerExchange);
    }
}

