/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.security;

import java.io.IOException;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.metrics.model.ApiError;

@Provider
@PreMatching
public class PersonaFilter
implements ContainerRequestFilter {
    private static final String TENANT_HEADER_NAME = "Hawkular-Tenant";
    private static final String TENANT_HEADER_NOT_ALLOWED = "The Hawkular-Tenant header is not allowed. The tenant is determined from the credentials supplied with the request";
    @Inject
    Instance<Persona> personaInstance;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String path = requestContext.getUriInfo().getPath();
        if (path.equals("/status") || path.equals("/")) {
            return;
        }
        if (requestContext.getHeaderString(TENANT_HEADER_NAME) != null) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ApiError(TENANT_HEADER_NOT_ALLOWED)).build());
            return;
        }
        Persona persona = (Persona)this.personaInstance.get();
        if (persona == null) {
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        } else {
            requestContext.getHeaders().putSingle((Object)TENANT_HEADER_NAME, (Object)persona.getIdAsUUID().toString());
        }
    }
}

