/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.handler;

import com.google.common.base.Strings;
import com.google.common.collect.ObjectArrays;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.metrics.api.jaxrs.StatsQueryRequest;
import org.hawkular.metrics.api.jaxrs.handler.MetricHandler;
import org.hawkular.metrics.api.jaxrs.handler.observer.MetricCreatedObserver;
import org.hawkular.metrics.api.jaxrs.handler.transformer.MinMaxTimestampTransformer;
import org.hawkular.metrics.api.jaxrs.param.DurationConverter;
import org.hawkular.metrics.api.jaxrs.param.PercentilesConverter;
import org.hawkular.metrics.api.jaxrs.param.TagsConverter;
import org.hawkular.metrics.api.jaxrs.util.ApiUtils;
import org.hawkular.metrics.api.jaxrs.util.MetricTypeTextConverter;
import org.hawkular.metrics.core.service.Functions;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.model.ApiError;
import org.hawkular.metrics.model.BucketPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.MixedMetricsRequest;
import org.hawkular.metrics.model.Percentile;
import org.hawkular.metrics.model.param.BucketConfig;
import org.hawkular.metrics.model.param.Duration;
import org.hawkular.metrics.model.param.Tags;
import org.hawkular.metrics.model.param.TimeRange;
import rx.Observable;
import rx.Observer;
import rx.functions.Func1;

@Path(value="/metrics")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(tags={"Metric"})
@ApplicationScoped
public class MetricHandler {
    @Inject
    private MetricsService metricsService;
    @Context
    private HttpHeaders httpHeaders;

    private String getTenant() {
        return (String)this.httpHeaders.getRequestHeaders().getFirst((Object)"Hawkular-Tenant");
    }

    @POST
    @Path(value="/")
    @ApiOperation(value="Create metric.", notes="Clients are not required to explicitly create a metric before storing data. Doing so however allows clients to prevent naming collisions and to specify tags and data retention.")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric created successfully"), @ApiResponse(code=400, message="Missing or invalid payload", response=ApiError.class), @ApiResponse(code=409, message="Metric with given id already exists", response=ApiError.class), @ApiResponse(code=500, message="Metric creation failed due to an unexpected error", response=ApiError.class)})
    public <T> void createMetric(@Suspended AsyncResponse asyncResponse, @ApiParam(required=true) Metric<T> metric, @ApiParam(value="Overwrite previously created metric if it exists. Defaults to false.", required=false) @DefaultValue(value="false") @QueryParam(value="overwrite") Boolean overwrite, @Context UriInfo uriInfo) {
        if (metric.getType() == null || !metric.getType().isUserType()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Metric type is invalid")));
        }
        MetricId id = new MetricId(this.getTenant(), metric.getMetricId().getType(), metric.getId());
        metric = new Metric(id, metric.getTags(), metric.getDataRetention());
        URI location = uriInfo.getBaseUriBuilder().path("/{type}/{id}").build(new Object[]{MetricTypeTextConverter.getLongForm((MetricType)id.getType()), id.getName()});
        this.metricsService.createMetric(metric, overwrite.booleanValue()).subscribe((Observer)new MetricCreatedObserver(asyncResponse, location));
    }

    @GET
    @Path(value="/tags/{tags}")
    @ApiOperation(value="Retrieve metrics' tag values", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Tags successfully retrieved."), @ApiResponse(code=204, message="No matching tags were found"), @ApiResponse(code=500, message="Unexpected error occurred while fetching tags.", response=ApiError.class)})
    public <T> void getTags(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Queried metric type", allowableValues="gauge, availability, counter") @QueryParam(value="type") MetricType<T> metricType, @ApiParam(value="Tag query") @PathParam(value="tags") Tags tags) {
        this.metricsService.getTagValues(this.getTenant(), metricType, tags.getTags()).map(ApiUtils::mapToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)));
    }

    @GET
    @Path(value="/")
    @ApiOperation(value="Find tenant's metric definitions.", notes="Does not include any metric values. ", response=Metric.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=200, message="Successfully retrieved at least one metric definition."), @ApiResponse(code=204, message="No metrics found."), @ApiResponse(code=400, message="Invalid type parameter type.", response=ApiError.class), @ApiResponse(code=500, message="Failed to retrieve metrics due to unexpected error.", response=ApiError.class)})
    public <T> void findMetrics(@Suspended AsyncResponse asyncResponse, @ApiParam(value="Queried metric type", required=false, allowableValues="gauge, availability, counter") @QueryParam(value="type") MetricType<T> metricType, @ApiParam(value="List of tags filters", required=false) @QueryParam(value="tags") Tags tags, @ApiParam(value="Regexp to match metricId, requires tags filtering", required=false) @QueryParam(value="id") String id) {
        if (metricType != null && !metricType.isUserType()) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Incorrect type param " + metricType.toString())));
            return;
        }
        Object[] metricFuncs = (Func1[])ObjectArrays.newArray(Func1.class, (int)0);
        if (!Strings.isNullOrEmpty((String)id)) {
            metricFuncs = (Func1[])ObjectArrays.concat((Object[])metricFuncs, (Object)this.metricsService.idFilter(id));
        }
        Observable metricObservable = tags == null ? this.metricsService.findMetrics(this.getTenant(), metricType) : this.metricsService.findMetricsWithFilters(this.getTenant(), metricType, tags.getTags(), (Func1[])metricFuncs);
        metricObservable.compose((Observable.Transformer)new MinMaxTimestampTransformer(this.metricsService)).toList().map(ApiUtils::collectionToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> {
            if (t instanceof PatternSyntaxException) {
                asyncResponse.resume((Object)ApiUtils.badRequest((Throwable)t));
            } else {
                asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t));
            }
        });
    }

    @Deprecated
    @POST
    @Path(value="/data")
    @ApiOperation(value="Deprecated. Please use /raw endpoint.")
    public void deprecatedAddMetricsData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of metrics", required=true) MixedMetricsRequest metricsRequest) {
        this.addMetricsData(asyncResponse, metricsRequest);
    }

    @POST
    @Path(value="/raw")
    @ApiOperation(value="Add data points for multiple metrics in a single call.")
    @ApiResponses(value={@ApiResponse(code=200, message="Adding data points succeeded."), @ApiResponse(code=400, message="Missing or invalid payload.", response=ApiError.class), @ApiResponse(code=500, message="Unexpected error happened while storing the data", response=ApiError.class)})
    public void addMetricsData(@Suspended AsyncResponse asyncResponse, @ApiParam(value="List of metrics", required=true) MixedMetricsRequest metricsRequest) {
        if (metricsRequest.isEmpty()) {
            asyncResponse.resume((Object)ApiUtils.emptyPayload());
            return;
        }
        Observable gauges = Functions.metricToObservable((String)this.getTenant(), (List)metricsRequest.getGauges(), (MetricType)MetricType.GAUGE);
        Observable availabilities = Functions.metricToObservable((String)this.getTenant(), (List)metricsRequest.getAvailabilities(), (MetricType)MetricType.AVAILABILITY);
        Observable counters = Functions.metricToObservable((String)this.getTenant(), (List)metricsRequest.getCounters(), (MetricType)MetricType.COUNTER);
        Observable strings = Functions.metricToObservable((String)this.getTenant(), (List)metricsRequest.getStrings(), (MetricType)MetricType.STRING);
        this.metricsService.addDataPoints(MetricType.GAUGE, gauges).mergeWith(this.metricsService.addDataPoints(MetricType.AVAILABILITY, availabilities)).mergeWith(this.metricsService.addDataPoints(MetricType.COUNTER, counters)).mergeWith(this.metricsService.addDataPoints(MetricType.STRING, strings)).subscribe(aVoid -> {}, t -> asyncResponse.resume((Object)ApiUtils.serverError((Throwable)t)), () -> asyncResponse.resume((Object)Response.ok().build()));
    }

    @POST
    @Path(value="/stats/query")
    public void findStats(@Suspended AsyncResponse asyncResponse, StatsQueryRequest query) {
        if (this.isMetricIdsEmpty(query) && query.getTags() == null) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Either the metrics or the tags property must be set")));
        }
        if (query.getBuckets() == null && query.getBucketDuration() == null) {
            asyncResponse.resume((Object)ApiUtils.badRequest((ApiError)new ApiError("Either the buckets or bucketDuration property must be set")));
            return;
        }
        Duration duration = query.getBucketDuration() == null ? null : new DurationConverter().fromString(query.getBucketDuration());
        TimeRange timeRange = new TimeRange(query.getStart(), query.getEnd());
        BucketConfig bucketsConfig = new BucketConfig(query.getBuckets(), duration, timeRange);
        List percentiles = query.getPercentiles() == null ? Collections.emptyList() : new PercentilesConverter().fromString(query.getPercentiles()).getPercentiles();
        List types = Collections.emptyList();
        if (query.getTypes() != null) {
            types = query.getTypes().stream().map(MetricType::fromTextCode).collect(Collectors.toList());
        }
        Observable gaugeStats = Observable.just(Collections.emptyMap());
        Observable counterStats = Observable.just(Collections.emptyMap());
        Observable availabilityStats = Observable.just(Collections.emptyMap());
        Observable gaugeRateStats = Observable.just(Collections.emptyMap());
        Observable counterRateStats = Observable.just(Collections.emptyMap());
        if (!query.getMetrics().isEmpty() && (query.getMetrics().containsKey(MetricType.GAUGE.getText()) || query.getMetrics().containsKey(MetricType.COUNTER.getText()) || query.getMetrics().containsKey(MetricType.AVAILABILITY.getText()))) {
            if (!this.isMetricsEmpty(query, MetricType.GAUGE)) {
                if (types.isEmpty()) {
                    gaugeStats = this.getGaugeStats(this.getMetricIds(query, MetricType.GAUGE), bucketsConfig, percentiles);
                } else if (types.contains(MetricType.GAUGE_RATE)) {
                    if (types.contains(MetricType.GAUGE)) {
                        gaugeStats = this.getGaugeStats(query, bucketsConfig, percentiles);
                        gaugeRateStats = this.getRateStats(this.getMetricIds(query, MetricType.GAUGE), MetricType.GAUGE, bucketsConfig, percentiles);
                    } else {
                        gaugeRateStats = this.getRateStats(this.getMetricIds(query, MetricType.GAUGE), MetricType.GAUGE, bucketsConfig, percentiles);
                    }
                } else {
                    gaugeStats = this.getGaugeStats(this.getMetricIds(query, MetricType.GAUGE), bucketsConfig, percentiles);
                }
            }
            if (!this.isMetricsEmpty(query, MetricType.COUNTER)) {
                if (types.isEmpty()) {
                    counterStats = this.getCounterStats(this.getMetricIds(query, MetricType.COUNTER), bucketsConfig, percentiles);
                } else if (types.contains(MetricType.COUNTER_RATE)) {
                    if (types.contains(MetricType.COUNTER)) {
                        counterStats = this.getCounterStats(this.getMetricIds(query, MetricType.COUNTER), bucketsConfig, percentiles);
                        counterRateStats = this.getRateStats(this.getMetricIds(query, MetricType.COUNTER), MetricType.COUNTER, bucketsConfig, percentiles);
                    } else {
                        counterRateStats = this.getRateStats(this.getMetricIds(query, MetricType.COUNTER), MetricType.COUNTER, bucketsConfig, percentiles);
                    }
                } else {
                    counterStats = this.getCounterStats(query, timeRange, bucketsConfig, percentiles);
                }
            }
            if (!this.isMetricsEmpty(query, MetricType.AVAILABILITY)) {
                availabilityStats = Observable.from((Iterable)((Iterable)query.getMetrics().get("availability"))).flatMap(id -> this.metricsService.findAvailabilityStats(new MetricId(this.getTenant(), MetricType.AVAILABILITY, id), timeRange.getStart(), timeRange.getEnd(), bucketsConfig.getBuckets()).map(bucketPoints -> new NamedBucketPoints(this, id, bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
            }
        } else {
            Func1[] filters = new Func1[]{};
            Tags tags = new TagsConverter().fromString(query.getTags());
            if (types.isEmpty()) {
                gaugeStats = this.getGaugeStatsFromTags(bucketsConfig, percentiles, filters, tags);
                counterStats = this.getCounterStatsFromTags(bucketsConfig, percentiles, filters, tags);
                availabilityStats = this.getAvailabilityStatsFromTags(bucketsConfig, filters, tags);
            } else {
                Observable ids;
                if (types.contains(MetricType.GAUGE) && types.contains(MetricType.GAUGE_RATE)) {
                    Observable gauges = this.metricsService.findMetricsWithFilters(this.getTenant(), MetricType.GAUGE, tags.getTags(), filters).cache();
                    gaugeStats = gauges.flatMap(gauge -> this.metricsService.findGaugeStats(gauge.getMetricId(), bucketsConfig, percentiles).map(bucketPoints -> new NamedBucketPoints(this, gauge.getMetricId().getName(), bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
                    ids = gauges.map(Metric::getMetricId);
                    gaugeRateStats = this.getRateStats(ids, MetricType.GAUGE, bucketsConfig, percentiles);
                } else if (types.contains(MetricType.GAUGE)) {
                    gaugeStats = this.getGaugeStatsFromTags(bucketsConfig, percentiles, filters, tags);
                } else {
                    Observable gauges = this.metricsService.findMetricsWithFilters(this.getTenant(), MetricType.GAUGE, tags.getTags(), filters);
                    ids = gauges.map(Metric::getMetricId);
                    gaugeRateStats = this.getRateStats(ids, MetricType.GAUGE, bucketsConfig, percentiles);
                }
                if (types.contains(MetricType.COUNTER) && types.contains(MetricType.COUNTER_RATE)) {
                    Observable counters = this.metricsService.findMetricsWithFilters(this.getTenant(), MetricType.COUNTER, tags.getTags(), filters).cache();
                    counterStats = counters.flatMap(counter -> this.metricsService.findCounterStats(counter.getMetricId(), timeRange.getStart(), timeRange.getEnd(), bucketsConfig.getBuckets(), percentiles).map(bucketPoints -> new NamedBucketPoints(this, counter.getMetricId().getName(), bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
                    ids = counters.map(Metric::getMetricId);
                    counterRateStats = this.getRateStats(ids, MetricType.COUNTER, bucketsConfig, percentiles);
                } else if (types.contains(MetricType.COUNTER)) {
                    counterStats = this.getCounterStatsFromTags(bucketsConfig, percentiles, filters, tags);
                } else {
                    Observable counters = this.metricsService.findMetricsWithFilters(this.getTenant(), MetricType.COUNTER, tags.getTags(), filters);
                    ids = counters.map(Metric::getMetricId);
                    counterRateStats = this.getRateStats(ids, MetricType.COUNTER, bucketsConfig, percentiles);
                }
                if (types.contains(MetricType.AVAILABILITY)) {
                    availabilityStats = this.getAvailabilityStatsFromTags(bucketsConfig, filters, tags);
                }
            }
        }
        Observable.zip((Observable)gaugeStats, (Observable)counterStats, (Observable)availabilityStats, (Observable)gaugeRateStats, (Observable)counterRateStats, (gaugeMap, counterMap, availabiltyMap, gaugeRateMap, counterRateMap) -> {
            HashMap<String, Map> stats = new HashMap<String, Map>();
            if (!gaugeMap.isEmpty()) {
                stats.put(MetricType.GAUGE.getText(), (Map)gaugeMap);
            }
            if (!counterMap.isEmpty()) {
                stats.put(MetricType.COUNTER.getText(), (Map)counterMap);
            }
            if (!availabiltyMap.isEmpty()) {
                stats.put(MetricType.AVAILABILITY.getText(), (Map)availabiltyMap);
            }
            if (!gaugeRateMap.isEmpty()) {
                stats.put(MetricType.GAUGE_RATE.getText(), (Map)gaugeRateMap);
            }
            if (!counterRateMap.isEmpty()) {
                stats.put(MetricType.COUNTER_RATE.getText(), (Map)counterRateMap);
            }
            return stats;
        }).first().map(ApiUtils::mapToResponse).subscribe(arg_0 -> ((AsyncResponse)asyncResponse).resume(arg_0), t -> asyncResponse.resume((Object)ApiUtils.error((Throwable)t)));
    }

    private Observable<Map<String, List<? extends BucketPoint>>> getCounterStatsFromTags(BucketConfig bucketsConfig, List<Percentile> percentiles, Func1[] filters, Tags tags) {
        Observable counters = this.metricsService.findMetricsWithFilters(this.getTenant(), MetricType.COUNTER, tags.getTags(), filters);
        Observable counterStats = counters.flatMap(counter -> this.metricsService.findCounterStats(counter.getMetricId(), bucketsConfig.getTimeRange().getStart(), bucketsConfig.getTimeRange().getEnd(), bucketsConfig.getBuckets(), percentiles).map(bucketPoints -> new NamedBucketPoints(this, counter.getMetricId().getName(), bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
        return counterStats;
    }

    private Observable<Map<String, List<? extends BucketPoint>>> getGaugeStatsFromTags(BucketConfig bucketsConfig, List<Percentile> percentiles, Func1[] filters, Tags tags) {
        Observable gauges = this.metricsService.findMetricsWithFilters(this.getTenant(), MetricType.GAUGE, tags.getTags(), filters);
        Observable gaugeStats = gauges.flatMap(gauge -> this.metricsService.findGaugeStats(gauge.getMetricId(), bucketsConfig, percentiles).map(bucketPoints -> new NamedBucketPoints(this, gauge.getMetricId().getName(), bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
        return gaugeStats;
    }

    private Observable<Map<String, List<? extends BucketPoint>>> getAvailabilityStatsFromTags(BucketConfig bucketsConfig, Func1[] filters, Tags tags) {
        Observable availabilities = this.metricsService.findMetricsWithFilters(this.getTenant(), MetricType.AVAILABILITY, tags.getTags(), filters);
        Observable availabilityStats = availabilities.flatMap(availability -> this.metricsService.findAvailabilityStats(availability.getMetricId(), bucketsConfig.getTimeRange().getStart(), bucketsConfig.getTimeRange().getEnd(), bucketsConfig.getBuckets()).map(bucketPoints -> new NamedBucketPoints(this, availability.getMetricId().getName(), bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
        return availabilityStats;
    }

    private Observable<Map<String, List<? extends BucketPoint>>> getGaugeStats(StatsQueryRequest query, BucketConfig bucketsConfig, List<Percentile> percentiles) {
        Observable gaugeStats = Observable.from((Iterable)((Iterable)query.getMetrics().get("gauge"))).flatMap(id -> this.metricsService.findGaugeStats(new MetricId(this.getTenant(), MetricType.GAUGE, id), bucketsConfig, percentiles).map(bucketPoints -> new NamedBucketPoints(this, id, bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
        return gaugeStats;
    }

    private Observable<Map<String, List<? extends BucketPoint>>> getGaugeStats(Observable<MetricId<Double>> ids, BucketConfig bucketConfig, List<Percentile> percentiles) {
        return ids.flatMap(id -> this.metricsService.findGaugeStats(id, bucketConfig, percentiles).map(bucketPoints -> new NamedBucketPoints(this, id.getName(), bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
    }

    private Observable<Map<String, List<? extends BucketPoint>>> getCounterStats(Observable<MetricId<Long>> ids, BucketConfig bucketConfig, List<Percentile> percentiles) {
        return ids.flatMap(id -> this.metricsService.findCounterStats(id, bucketConfig.getTimeRange().getStart(), bucketConfig.getTimeRange().getEnd(), bucketConfig.getBuckets(), percentiles).map(bucketPoints -> new NamedBucketPoints(this, id.getName(), bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
    }

    private Observable<Map<String, List<? extends BucketPoint>>> getCounterStats(StatsQueryRequest query, TimeRange timeRange, BucketConfig bucketsConfig, List<Percentile> percentiles) {
        Observable counterStats = Observable.from((Iterable)((Iterable)query.getMetrics().get("counter"))).flatMap(id -> this.metricsService.findCounterStats(new MetricId(this.getTenant(), MetricType.COUNTER, id), timeRange.getStart(), timeRange.getEnd(), bucketsConfig.getBuckets(), percentiles).map(bucketPoints -> new NamedBucketPoints(this, id, bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
        return counterStats;
    }

    private <T> Observable<MetricId<T>> getMetricIds(StatsQueryRequest query, MetricType<T> type) {
        return Observable.from((Iterable)((Iterable)query.getMetrics().get(type.getText()))).map(id -> new MetricId(this.getTenant(), type, id));
    }

    private <T> Observable<MetricId<T>> getMetricIds(Tags tags, MetricType<T> type) {
        return this.metricsService.findMetricsWithFilters(this.getTenant(), type, tags.getTags(), null).map(Metric::getMetricId);
    }

    private <T extends Number> Observable<Map<String, List<? extends BucketPoint>>> getRateStats(Observable<MetricId<T>> ids, MetricType<T> type, BucketConfig bucketConfig, List<Percentile> percentiles) {
        return ids.flatMap(id -> this.metricsService.findRateStats(id, bucketConfig.getTimeRange().getStart(), bucketConfig.getTimeRange().getEnd(), bucketConfig.getBuckets(), percentiles).map(bucketPoints -> new NamedBucketPoints(this, id.getName(), bucketPoints))).collect(HashMap::new, (statsMap, namedBucketPoints) -> statsMap.put(namedBucketPoints.id, namedBucketPoints.bucketPoints));
    }

    private <T> boolean isMetricsEmpty(StatsQueryRequest query, MetricType<T> type) {
        return query.getMetrics().get(type.getText()) == null || ((List)query.getMetrics().get(type.getText())).isEmpty();
    }

    private boolean isMetricIdsEmpty(StatsQueryRequest query) {
        if (query.getMetrics().isEmpty()) {
            return true;
        }
        return query.getMetrics().getOrDefault("gauge", Collections.emptyList()).isEmpty() && query.getMetrics().getOrDefault("counter", Collections.emptyList()).isEmpty() && query.getMetrics().getOrDefault("availability", Collections.emptyList()).isEmpty();
    }
}

