/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.component.insert;

import java.util.Collections;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSRuntimeException;
import javax.jms.MessageListener;
import javax.jms.Queue;
import org.hawkular.metrics.api.jaxrs.ServiceReady;
import org.hawkular.metrics.api.jaxrs.ServiceReadyEvent;
import org.hawkular.metrics.api.jaxrs.util.Eager;
import org.hawkular.metrics.component.insert.NewDataListener;
import org.hawkular.metrics.component.publish.AvailDataMessage;
import org.hawkular.metrics.component.publish.MetricDataMessage;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.jboss.logging.Logger;
import rx.Observable;
import rx.Subscriber;

@ApplicationScoped
@Eager
public class NewDataListener {
    private static final Logger LOG = Logger.getLogger(NewDataListener.class);
    @Resource(mappedName="java:/queue/hawkular/metrics/gauges/new")
    Queue gaugesQueue;
    @Resource(mappedName="java:/queue/hawkular/metrics/counters/new")
    Queue countersQueue;
    @Resource(mappedName="java:/queue/hawkular/metrics/availability/new")
    Queue availabilityQueue;
    @Resource(name="java:/HawkularBusConnectionFactory")
    private ConnectionFactory connectionFactory;
    @Inject
    MetricsService metricsService;
    private JMSContext context;
    private JMSConsumer gaugesConsumer;
    private JMSConsumer countersConsumer;
    private JMSConsumer availabilityConsumer;

    public void onMetricsServiceReady(@Observes @ServiceReady ServiceReadyEvent event) {
        this.context = this.connectionFactory.createContext();
        this.gaugesConsumer = this.context.createConsumer((Destination)this.gaugesQueue);
        this.gaugesConsumer.setMessageListener((MessageListener)new /* Unavailable Anonymous Inner Class!! */);
        this.countersConsumer = this.context.createConsumer((Destination)this.countersQueue);
        this.countersConsumer.setMessageListener((MessageListener)new /* Unavailable Anonymous Inner Class!! */);
        this.availabilityConsumer = this.context.createConsumer((Destination)this.availabilityQueue);
        this.availabilityConsumer.setMessageListener((MessageListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void onGaugeData(MetricDataMessage.MetricData metricData) {
        Observable metrics = Observable.from((Iterable)metricData.getData()).map(singleMetric -> {
            MetricId id = new MetricId(metricData.getTenantId(), MetricType.GAUGE, singleMetric.getSource());
            DataPoint dataPoint = new DataPoint(Long.valueOf(singleMetric.getTimestamp()), (Object)singleMetric.getValue());
            return new Metric(id, Collections.singletonList(dataPoint));
        });
        this.metricsService.addDataPoints(MetricType.GAUGE, metrics).subscribe((Subscriber)new NewDataSubscriber(null));
    }

    private void onCounterData(MetricDataMessage.MetricData metricData) {
        Observable metrics = Observable.from((Iterable)metricData.getData()).map(singleMetric -> {
            MetricId id = new MetricId(metricData.getTenantId(), MetricType.COUNTER, singleMetric.getSource());
            long value = (long)singleMetric.getValue();
            DataPoint dataPoint = new DataPoint(Long.valueOf(singleMetric.getTimestamp()), (Object)value);
            return new Metric(id, Collections.singletonList(dataPoint));
        });
        this.metricsService.addDataPoints(MetricType.COUNTER, metrics).subscribe((Subscriber)new NewDataSubscriber(null));
    }

    private void onAvailData(AvailDataMessage.AvailData availData) {
        Observable metrics = Observable.from((Iterable)availData.getData()).map(singleMetric -> {
            MetricId id = new MetricId(singleMetric.getTenantId(), MetricType.AVAILABILITY, singleMetric.getId());
            AvailabilityType availabilityType = AvailabilityType.fromString((String)singleMetric.getAvail());
            DataPoint dataPoint = new DataPoint(Long.valueOf(singleMetric.getTimestamp()), (Object)availabilityType);
            return new Metric(id, Collections.singletonList(dataPoint));
        });
        this.metricsService.addDataPoints(MetricType.AVAILABILITY, metrics).subscribe((Subscriber)new NewDataSubscriber(null));
    }

    @PreDestroy
    void shutdown() {
        this.closeQuietly(this.gaugesConsumer);
        this.closeQuietly(this.countersConsumer);
        this.closeQuietly(this.availabilityConsumer);
        if (this.context != null) {
            try {
                this.context.close();
            }
            catch (JMSRuntimeException jMSRuntimeException) {
                // empty catch block
            }
        }
    }

    private void closeQuietly(JMSConsumer jmsConsumer) {
        if (jmsConsumer != null) {
            try {
                jmsConsumer.close();
            }
            catch (JMSRuntimeException jMSRuntimeException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ void access$000(NewDataListener x0, MetricDataMessage.MetricData x1) {
        x0.onGaugeData(x1);
    }

    static /* synthetic */ void access$100(NewDataListener x0, MetricDataMessage.MetricData x1) {
        x0.onCounterData(x1);
    }

    static /* synthetic */ void access$200(NewDataListener x0, AvailDataMessage.AvailData x1) {
        x0.onAvailData(x1);
    }

    static /* synthetic */ Logger access$400() {
        return LOG;
    }
}

