/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.api.jaxrs.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.fasterxml.jackson.AvailabilityTypeDeserializer;
import org.hawkular.metrics.model.fasterxml.jackson.AvailabilityTypeSerializer;
import org.hawkular.metrics.model.fasterxml.jackson.MetricTypeDeserializer;

@ApplicationScoped
public class ObjectMapperProducer {
    private ObjectMapper mapper;

    @PostConstruct
    public void initMapper() {
        this.mapper = new ObjectMapper();
        this.mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false);
        this.mapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(AvailabilityType.class, (JsonDeserializer)new AvailabilityTypeDeserializer());
        module.addDeserializer(MetricType.class, (JsonDeserializer)new MetricTypeDeserializer());
        module.addSerializer(AvailabilityType.class, (JsonSerializer)new AvailabilityTypeSerializer());
        this.mapper.registerModule((Module)module);
    }

    @Produces
    public ObjectMapper getMapper() {
        return this.mapper;
    }
}

