/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import com.google.common.base.CharMatcher;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.format.big.BigFormat;

public interface SSTableFormat {
    public static final boolean enableSSTableDevelopmentTestMode = Boolean.valueOf(System.getProperty("cassandra.test.sstableformatdevelopment", "false"));

    public Version getLatestVersion();

    public Version getVersion(String var1);

    public SSTableWriter.Factory getWriterFactory();

    public SSTableReader.Factory getReaderFactory();

    public RowIndexEntry.IndexSerializer<?> getIndexSerializer(CFMetaData var1, Version var2, SerializationHeader var3);

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type LEGACY = new Type("big", BigFormat.instance);
        public static final /* enum */ Type BIG = new Type("big", BigFormat.instance);
        public final SSTableFormat info;
        public final String name;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(String name, SSTableFormat info) {
            assert (!CharMatcher.DIGIT.matchesAllOf(name));
            this.name = name;
            this.info = info;
        }

        public static Type validate(String name) {
            for (Type valid : Type.values()) {
                if (valid == LEGACY || !valid.name.equalsIgnoreCase(name)) continue;
                return valid;
            }
            throw new IllegalArgumentException("No Type constant " + name);
        }

        static {
            $VALUES = new Type[]{LEGACY, BIG};
        }
    }
}

