/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.core.service.log.CoreLogger;
import org.hawkular.metrics.core.service.log.CoreLogging;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.tasks.api.Task2;
import rx.Observable;
import rx.functions.Action1;

public class GenerateRate
implements Action1<Task2> {
    private static final CoreLogger log = CoreLogging.getCoreLogger(GenerateRate.class);
    public static final String TASK_NAME = "generate-rates";
    private MetricsService metricsService;

    public GenerateRate(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    public void call(Task2 task) {
        log.debugf("Generating rate for %s", task);
        String tenant = (String)task.getParameters().get("tenant");
        long start = task.getTrigger().getTriggerTime();
        long end = start + TimeUnit.MINUTES.toMillis(1L);
        Observable rates = this.metricsService.findMetrics(tenant, MetricType.COUNTER).flatMap(counter -> this.metricsService.findDataPoints(counter.getMetricId(), start, end, 0, Order.DESC).take(1).map(dataPoint -> ((Long)dataPoint.getValue()).doubleValue() / (double)(end - start) * 1000.0 * 60.0).map(rate -> new Metric<Double>(new MetricId<Double>(tenant, MetricType.COUNTER_RATE, counter.getMetricId().getName()), Collections.singletonList(new DataPoint<Double>(start, (Double)rate)))));
        Observable<Void> updates = this.metricsService.addDataPoints(MetricType.COUNTER_RATE, rates);
        CountDownLatch latch = new CountDownLatch(1);
        updates.subscribe(aVoid -> {}, t -> {
            log.warnFailedToPersistRates(tenant, start, end, (Throwable)t);
            latch.countDown();
        }, () -> {
            if (log.isDebugEnabled()) {
                log.debug("Successfully persisted rate data for {tenant= " + tenant + ", start= " + start + ", end= " + end + "}");
            }
            latch.countDown();
        });
        try {
            latch.await();
        }
        catch (InterruptedException ignored) {
            // empty catch block
        }
    }
}

