/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.model.AvailabilityBucketPoint;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.Buckets;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.NumericBucketPoint;
import org.hawkular.metrics.model.TaggedBucketPoint;
import org.hawkular.metrics.model.Tenant;
import org.hawkular.metrics.model.param.BucketConfig;
import rx.Observable;
import rx.functions.Func1;

public interface MetricsService {
    public Observable<Void> createTenant(Tenant var1, boolean var2);

    public Observable<Tenant> getTenants();

    public Observable<Void> createMetric(Metric<?> var1, boolean var2);

    public <T> Observable<Metric<T>> findMetric(MetricId<T> var1);

    public <T> Observable<Metric<T>> findMetrics(String var1, MetricType<T> var2);

    public <T> Observable<Metric<T>> findMetricsWithFilters(String var1, MetricType<T> var2, Map<String, String> var3, Func1<Metric<T>, Boolean> ... var4);

    public Observable<Map<String, Set<String>>> getTagValues(String var1, MetricType<?> var2, Map<String, String> var3);

    public Observable<Map<String, String>> getMetricTags(MetricId<?> var1);

    public Observable<Void> addTags(Metric<?> var1, Map<String, String> var2);

    public Observable<Void> deleteTags(Metric<?> var1, Set<String> var2);

    public <T> Observable<Void> addDataPoints(MetricType<T> var1, Observable<Metric<T>> var2);

    public <T> Observable<DataPoint<T>> findDataPoints(MetricId<T> var1, long var2, long var4, int var6, Order var7);

    public <T> Observable<T> findGaugeData(MetricId<Double> var1, long var2, long var4, Func1<Observable<DataPoint<Double>>, Observable<T>> ... var6);

    public Observable<List<NumericBucketPoint>> findGaugeStats(MetricId<Double> var1, BucketConfig var2, List<Double> var3);

    public Observable<Map<String, TaggedBucketPoint>> findGaugeStats(MetricId<Double> var1, Map<String, String> var2, long var3, long var5, List<Double> var7);

    public <T extends Number> Observable<List<NumericBucketPoint>> findNumericStats(String var1, MetricType<T> var2, Map<String, String> var3, long var4, long var6, Buckets var8, List<Double> var9, boolean var10);

    public <T extends Number> Observable<List<NumericBucketPoint>> findNumericStats(String var1, MetricType<T> var2, List<String> var3, long var4, long var6, Buckets var8, List<Double> var9, boolean var10);

    public Observable<DataPoint<AvailabilityType>> findAvailabilityData(MetricId<AvailabilityType> var1, long var2, long var4, boolean var6, int var7, Order var8);

    public Observable<List<AvailabilityBucketPoint>> findAvailabilityStats(MetricId<AvailabilityType> var1, long var2, long var4, Buckets var6);

    public Observable<DataPoint<String>> findStringData(MetricId<String> var1, long var2, long var4, boolean var6, int var7, Order var8);

    public Observable<Boolean> idExists(MetricId<?> var1);

    public Observable<List<NumericBucketPoint>> findCounterStats(MetricId<Long> var1, long var2, long var4, Buckets var6, List<Double> var7);

    public Observable<Map<String, TaggedBucketPoint>> findCounterStats(MetricId<Long> var1, Map<String, String> var2, long var3, long var5, List<Double> var7);

    public Observable<DataPoint<Double>> findRateData(MetricId<? extends Number> var1, long var2, long var4, int var6, Order var7);

    public Observable<List<NumericBucketPoint>> findRateStats(MetricId<? extends Number> var1, long var2, long var4, Buckets var6, List<Double> var7);

    public Observable<List<long[]>> getPeriods(MetricId<Double> var1, Predicate<Double> var2, long var3, long var5);

    public Observable<Metric<?>> insertedDataEvents();

    public <T> Func1<Metric<T>, Boolean> idFilter(String var1);
}

