/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Map;

public enum Order {
    ASC("asc"),
    DESC("desc");

    private static final Map<String, Order> texts;
    private String text;

    private Order(String text) {
        this.text = text;
    }

    public static Order fromText(String text) {
        Preconditions.checkArgument(text != null, "text is null");
        Order order = texts.get(text);
        if (order == null) {
            throw new IllegalArgumentException(text + " is not a recognized order");
        }
        return order;
    }

    public static Order defaultValue(int limit, Long start, Long end) {
        return limit > 0 && start != null && end == null ? ASC : DESC;
    }

    public String toString() {
        return this.text;
    }

    static {
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.orderedBy(String.CASE_INSENSITIVE_ORDER);
        for (Order order : Order.values()) {
            builder.put(order.text, (Object)order);
        }
        texts = builder.build();
    }
}

