/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.transformers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.rank.PSquarePercentile;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.hawkular.metrics.core.service.PercentileWrapper;
import org.hawkular.metrics.model.Buckets;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.NumericBucketPoint;
import org.hawkular.metrics.model.Percentile;

public final class NumericDataPointCollector {
    public static Function<Double, PercentileWrapper> createPercentile = p -> new PercentileWrapper((Double)p){
        PSquarePercentile percentile;
        final /* synthetic */ Double val$p;
        {
            this.val$p = d;
            this.percentile = new PSquarePercentile(this.val$p);
        }

        @Override
        public synchronized void addValue(double value) {
            this.percentile.increment(value);
        }

        @Override
        public synchronized double getResult() {
            return this.percentile.getResult();
        }
    };
    private final Buckets buckets;
    private final int bucketIndex;
    private int samples = 0;
    private Min min = new Min();
    private Mean average = new Mean();
    private PercentileWrapper median = createPercentile.apply(50.0);
    private Max max = new Max();
    private Sum sum = new Sum();
    private List<PSquarePercentile> percentiles;

    public NumericDataPointCollector(Buckets buckets, int bucketIndex, List<Double> percentileList) {
        this.buckets = buckets;
        this.bucketIndex = bucketIndex;
        this.percentiles = new ArrayList<PSquarePercentile>();
        percentileList.stream().forEach(d -> this.percentiles.add(new PSquarePercentile((double)d)));
    }

    public void increment(DataPoint<? extends Number> dataPoint) {
        Number value = dataPoint.getValue();
        this.min.increment(value.doubleValue());
        this.average.increment(value.doubleValue());
        this.median.addValue(value.doubleValue());
        this.max.increment(value.doubleValue());
        this.sum.increment(value.doubleValue());
        ++this.samples;
        this.percentiles.stream().forEach(p -> p.increment(value.doubleValue()));
    }

    public NumericBucketPoint toBucketPoint() {
        long from = this.buckets.getBucketStart(this.bucketIndex);
        long to = from + this.buckets.getStep();
        return new NumericBucketPoint.Builder(from, to).setMin(this.min.getResult()).setAvg(this.average.getResult()).setMedian(this.median.getResult()).setMax(this.max.getResult()).setSum(this.sum.getResult()).setSamples(this.samples).setPercentiles(this.percentiles.stream().map(p -> new Percentile(p.quantile(), p.getResult())).collect(Collectors.toList())).build();
    }
}

