/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model;

import java.util.List;
import java.util.Map;
import org.hawkular.metrics.model.BucketPoint;
import org.hawkular.metrics.model.Buckets;

public final class AvailabilityBucketPoint
extends BucketPoint {
    private final Long downtimeDuration;
    private final Long lastDowntime;
    private final Double uptimeRatio;
    private final Long downtimeCount;

    protected AvailabilityBucketPoint(long start, long end, long downtimeDuration, long lastDowntime, double uptimeRatio, long downtimeCount) {
        super(start, end);
        this.downtimeDuration = downtimeDuration;
        this.lastDowntime = lastDowntime;
        this.uptimeRatio = this.getDoubleValue(uptimeRatio);
        this.downtimeCount = downtimeCount;
    }

    public Long getDowntimeDuration() {
        if (this.isEmpty()) {
            return null;
        }
        return this.downtimeDuration;
    }

    public Long getLastDowntime() {
        if (this.isEmpty()) {
            return null;
        }
        return this.lastDowntime;
    }

    public Double getUptimeRatio() {
        return this.uptimeRatio;
    }

    public Long getDowntimeCount() {
        if (this.isEmpty()) {
            return null;
        }
        return this.downtimeCount;
    }

    @Override
    public boolean isEmpty() {
        return this.uptimeRatio == null;
    }

    public String toString() {
        return "AvailabilityBucketPoint[start=" + this.getStart() + ", end=" + this.getEnd() + ", downtimeDuration=" + this.downtimeDuration + ", lastDowntime=" + this.lastDowntime + ", uptimeRatio=" + this.uptimeRatio + ", downtimeCount=" + this.downtimeCount + ", isEmpty=" + this.isEmpty() + ']';
    }

    public static List<AvailabilityBucketPoint> toList(Map<Long, AvailabilityBucketPoint> pointMap, Buckets buckets) {
        return BucketPoint.toList(pointMap, buckets, (start, end) -> new Builder((long)start, (long)end).build());
    }

    public static class Builder {
        private final long start;
        private final long end;
        private long downtimeDuration = 0L;
        private long lastDowntime = 0L;
        private double uptimeRatio = Double.NaN;
        private long downtimeCount = 0L;

        public Builder(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public Builder setDowntimeDuration(long downtimeDuration) {
            this.downtimeDuration = downtimeDuration;
            return this;
        }

        public Builder setLastDowntime(long lastDowntime) {
            this.lastDowntime = lastDowntime;
            return this;
        }

        public Builder setUptimeRatio(double uptimeRatio) {
            this.uptimeRatio = uptimeRatio;
            return this;
        }

        public Builder setDowntimeCount(long downtimeCount) {
            this.downtimeCount = downtimeCount;
            return this;
        }

        public AvailabilityBucketPoint build() {
            return new AvailabilityBucketPoint(this.start, this.end, this.downtimeDuration, this.lastDowntime, this.uptimeRatio, this.downtimeCount);
        }
    }
}

