/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.scheduler.api;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.datetime.DateTimeService;
import org.hawkular.metrics.scheduler.api.Trigger;
import org.joda.time.Duration;

public class RepeatingTrigger
implements Trigger {
    private Long triggerTime;
    private Long interval;
    private Long delay;
    private Integer repeatCount;
    private Integer executionCount;

    private RepeatingTrigger() {
    }

    private RepeatingTrigger(Long interval, Long delay, Integer repeatCount) {
        if (interval == null && delay == null) {
            this.triggerTime = DateTimeService.currentMinute().plusMinutes(1).getMillis();
        }
        this.interval = interval;
        this.delay = delay == null ? 0L : delay;
        this.repeatCount = repeatCount;
        this.executionCount = 1;
        this.triggerTime = DateTimeService.getTimeSlice(DateTimeService.now.get().getMillis() + this.delay, Duration.standardMinutes(1L));
    }

    public RepeatingTrigger(long interval, long delay, long triggerTime, int repeatCount, int executionCount) {
        this.interval = interval;
        this.delay = delay;
        this.triggerTime = triggerTime;
        this.executionCount = executionCount;
        this.repeatCount = repeatCount == 0 ? null : Integer.valueOf(repeatCount);
        this.executionCount = executionCount;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getDelay() {
        return this.delay;
    }

    @Override
    public long getTriggerTime() {
        return this.triggerTime;
    }

    public Integer getRepeatCount() {
        return this.repeatCount;
    }

    public int getExecutionCount() {
        return this.executionCount;
    }

    @Override
    public Trigger nextTrigger() {
        if (this.repeatCount != null && this.executionCount + 1 > this.repeatCount) {
            return null;
        }
        RepeatingTrigger next = new RepeatingTrigger();
        next.interval = this.interval;
        next.delay = this.delay;
        next.triggerTime = this.triggerTime + this.interval;
        next.repeatCount = this.repeatCount;
        next.executionCount = this.executionCount + 1;
        return next;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepeatingTrigger that = (RepeatingTrigger)o;
        return Objects.equals(this.triggerTime, that.triggerTime) && Objects.equals(this.interval, that.interval) && Objects.equals(this.delay, that.delay);
    }

    public int hashCode() {
        return Objects.hash(this.triggerTime, this.interval, this.delay);
    }

    public String toString() {
        return "RepeatingTrigger{triggerTime=" + this.triggerTime + ", interval=" + this.interval + ", delay=" + this.delay + '}';
    }

    public static class Builder {
        private Long interval;
        private Long delay;
        private Integer repeatCount;

        public Builder withInterval(int interval, TimeUnit timeUnit) {
            this.interval = TimeUnit.MILLISECONDS.convert(interval, timeUnit);
            return this;
        }

        public Builder withDelay(int delay, TimeUnit timeUnit) {
            this.delay = TimeUnit.MILLISECONDS.convert(delay, timeUnit);
            return this;
        }

        public Builder withRepeatCount(int count) {
            this.repeatCount = count;
            return this;
        }

        public RepeatingTrigger build() {
            return new RepeatingTrigger(this.interval, this.delay, this.repeatCount);
        }
    }
}

