/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.utils.concurrent.OpOrder;

public class ReadExecutionController
implements AutoCloseable {
    private final OpOrder.Group baseOp;
    private final OpOrder.Group indexOp;
    private final OpOrder.Group writeOp;

    private ReadExecutionController(OpOrder.Group baseOp, OpOrder.Group indexOp, OpOrder.Group writeOp) {
        this.baseOp = baseOp;
        this.indexOp = indexOp;
        this.writeOp = writeOp;
    }

    public OpOrder.Group baseReadOpOrderGroup() {
        return this.baseOp;
    }

    public OpOrder.Group indexReadOpOrderGroup() {
        return this.indexOp;
    }

    public OpOrder.Group writeOpOrderGroup() {
        return this.writeOp;
    }

    public static ReadExecutionController empty() {
        return new ReadExecutionController(null, null, null);
    }

    public static ReadExecutionController forReadOp(OpOrder.Group readOp) {
        return new ReadExecutionController(readOp, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReadExecutionController forCommand(ReadCommand command) {
        ColumnFamilyStore baseCfs = Keyspace.openAndGetStore(command.metadata());
        ColumnFamilyStore indexCfs = ReadExecutionController.maybeGetIndexCfs(baseCfs, command);
        if (indexCfs == null) {
            return new ReadExecutionController(baseCfs.readOrdering.start(), null, null);
        }
        OpOrder.Group baseOp = null;
        OpOrder.Group indexOp = null;
        OpOrder.Group writeOp = null;
        try {
            baseOp = baseCfs.readOrdering.start();
            indexOp = indexCfs.readOrdering.start();
            writeOp = Keyspace.writeOrder.start();
            return new ReadExecutionController(baseOp, indexOp, writeOp);
        }
        catch (RuntimeException e) {
            assert (writeOp == null);
            try {
                if (baseOp != null) {
                    baseOp.close();
                }
            }
            finally {
                if (indexOp != null) {
                    indexOp.close();
                }
            }
            throw e;
        }
    }

    private static ColumnFamilyStore maybeGetIndexCfs(ColumnFamilyStore baseCfs, ReadCommand command) {
        Index index = command.getIndex(baseCfs);
        return index == null ? null : (ColumnFamilyStore)index.getBackingTable().orElse(null);
    }

    @Override
    public void close() {
        try {
            if (this.baseOp != null) {
                this.baseOp.close();
            }
        }
        finally {
            if (this.indexOp != null) {
                try {
                    this.indexOp.close();
                }
                finally {
                    this.writeOp.close();
                }
            }
        }
    }
}

