/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.transformers;

import com.datastax.driver.core.Row;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.joda.time.Duration;
import rx.Observable;

public class MetricFromDataRowTransformer<T>
implements Observable.Transformer<Row, Metric<T>> {
    private final MetricType<T> type;
    private final String tenantId;
    private final int defaultDataRetention;

    public MetricFromDataRowTransformer(String tenantId, MetricType<T> type, int defaultTTL) {
        this.type = type;
        this.tenantId = tenantId;
        this.defaultDataRetention = (int)Duration.standardSeconds(defaultTTL).getStandardDays();
    }

    public Observable<Metric<T>> call(Observable<Row> rows) {
        return rows.map(row -> {
            MetricId<T> metricId = new MetricId<T>(this.tenantId, this.type, row.getString(0));
            return new Metric<T>(metricId, this.defaultDataRetention);
        });
    }
}

