/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SystemProperties {
    private static final Logger logger = LoggerFactory.getLogger(SystemProperties.class);

    SystemProperties() {
    }

    static int getInt(String key, int defaultValue) {
        String stringValue = System.getProperty(key);
        if (stringValue == null) {
            logger.debug("{} is undefined, using default value {}", (Object)key, (Object)defaultValue);
            return defaultValue;
        }
        try {
            int value = Integer.parseInt(stringValue);
            logger.warn("{} is defined, using value {}", (Object)key, (Object)value);
            return value;
        }
        catch (NumberFormatException e) {
            logger.warn("{} is defined but could not parse value {}, using default value {}", key, stringValue, defaultValue);
            return defaultValue;
        }
    }

    static boolean getBoolean(String key, boolean defaultValue) {
        String stringValue = System.getProperty(key);
        if (stringValue == null) {
            logger.debug("{} is undefined, using default value {}", (Object)key, (Object)defaultValue);
            return defaultValue;
        }
        try {
            boolean value = Boolean.parseBoolean(stringValue);
            logger.warn("{} is defined, using value {}", (Object)key, (Object)value);
            return value;
        }
        catch (NumberFormatException e) {
            logger.warn("{} is defined but could not parse value {}, using default value {}", key, stringValue, defaultValue);
            return defaultValue;
        }
    }
}

