/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.messages.ResultMessage;

public abstract class AuthenticationStatement
extends ParsedStatement
implements CQLStatement {
    @Override
    public ParsedStatement.Prepared prepare() {
        return new ParsedStatement.Prepared(this);
    }

    @Override
    public int getBoundTerms() {
        return 0;
    }

    @Override
    public ResultMessage execute(QueryState state, QueryOptions options) throws RequestExecutionException, RequestValidationException {
        return this.execute(state.getClientState());
    }

    public abstract ResultMessage execute(ClientState var1) throws RequestExecutionException, RequestValidationException;

    @Override
    public ResultMessage executeInternal(QueryState state, QueryOptions options) {
        throw new UnsupportedOperationException();
    }

    public void checkPermission(ClientState state, Permission required, RoleResource resource) throws UnauthorizedException {
        try {
            state.ensureHasPermission(required, resource);
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException(String.format("User %s does not have sufficient privileges to perform the requested operation", state.getUser().getName()));
        }
    }
}

