/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.pager.SinglePartitionPager;

public class QueryPagers {
    private QueryPagers() {
    }

    public static int countPaged(CFMetaData metadata, DecoratedKey key, ColumnFilter columnFilter, ClusteringIndexFilter filter, DataLimits limits, ConsistencyLevel consistencyLevel, ClientState state, int pageSize, int nowInSec, boolean isForThrift) throws RequestValidationException, RequestExecutionException {
        SinglePartitionReadCommand command = SinglePartitionReadCommand.create(isForThrift, metadata, nowInSec, columnFilter, RowFilter.NONE, limits, key, filter);
        SinglePartitionPager pager = new SinglePartitionPager(command, null, 4);
        int count = 0;
        while (!pager.isExhausted()) {
            PartitionIterator iter2 = pager.fetchPage(pageSize, consistencyLevel, state);
            Throwable throwable = null;
            try {
                DataLimits.Counter counter = limits.newCounter(nowInSec, true);
                PartitionIterators.consume(counter.applyTo(iter2));
                count += counter.counted();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (iter2 == null) continue;
                if (throwable != null) {
                    try {
                        iter2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                iter2.close();
            }
        }
        return count;
    }
}

