/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Token;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public final class TokenRange
implements Comparable<TokenRange> {
    private final Token start;
    private final Token end;
    @VisibleForTesting
    final Token.Factory factory;

    TokenRange(Token start, Token end, Token.Factory factory) {
        this.start = start;
        this.end = end;
        this.factory = factory;
    }

    public Token getStart() {
        return this.start;
    }

    public Token getEnd() {
        return this.end;
    }

    public List<TokenRange> splitEvenly(int numberOfSplits) {
        if (numberOfSplits < 1) {
            throw new IllegalArgumentException(String.format("numberOfSplits (%d) must be greater than 0.", numberOfSplits));
        }
        if (this.isEmpty()) {
            throw new IllegalArgumentException("Can't split empty range " + this);
        }
        ArrayList<TokenRange> tokenRanges = new ArrayList<TokenRange>();
        List<Token> splitPoints = this.factory.split(this.start, this.end, numberOfSplits);
        Token splitStart = this.start;
        for (Token splitEnd : splitPoints) {
            tokenRanges.add(new TokenRange(splitStart, splitEnd, this.factory));
            splitStart = splitEnd;
        }
        tokenRanges.add(new TokenRange(splitStart, this.end, this.factory));
        return tokenRanges;
    }

    public boolean isEmpty() {
        return this.start.equals(this.end) && !this.start.equals(this.factory.minToken());
    }

    public boolean isWrappedAround() {
        return this.start.compareTo(this.end) > 0 && !this.end.equals(this.factory.minToken());
    }

    public List<TokenRange> unwrap() {
        if (this.isWrappedAround()) {
            return ImmutableList.of(new TokenRange(this.start, this.factory.minToken(), this.factory), new TokenRange(this.factory.minToken(), this.end, this.factory));
        }
        return ImmutableList.of(this);
    }

    public boolean intersects(TokenRange that) {
        if (this.isEmpty() || that.isEmpty()) {
            return false;
        }
        return this.contains(that.start, true) || this.contains(that.end, false) || that.contains(this.start, true) || that.contains(this.end, false);
    }

    public List<TokenRange> intersectWith(TokenRange that) {
        if (!this.intersects(that)) {
            throw new IllegalArgumentException("The two ranges do not intersect, use intersects() before calling this method");
        }
        ArrayList<TokenRange> intersected = Lists.newArrayList();
        List<TokenRange> unwrappedForThis = this.unwrap();
        List<TokenRange> unwrappedForThat = that.unwrap();
        for (TokenRange t1 : unwrappedForThis) {
            for (TokenRange t2 : unwrappedForThat) {
                if (!t1.intersects(t2)) continue;
                intersected.add(new TokenRange(t1.contains(t2.start, true) ? t2.start : t1.start, t1.contains(t2.end, false) ? t2.end : t1.end, this.factory));
            }
        }
        if (intersected.size() == 2) {
            TokenRange t1 = (TokenRange)intersected.get(0);
            TokenRange t2 = (TokenRange)intersected.get(1);
            if (t1.end.equals(t2.start) || t2.end.equals(t1.start)) {
                return ImmutableList.of(t1.mergeWith(t2));
            }
        }
        return intersected;
    }

    public boolean contains(Token token) {
        return this.contains(token, false);
    }

    private boolean contains(Token token, boolean isStart) {
        boolean isBeforeEnd;
        boolean isAfterStart;
        boolean bl = isStart ? token.compareTo(this.start) >= 0 : (isAfterStart = token.compareTo(this.start) > 0);
        boolean bl2 = this.end.equals(this.factory.minToken()) || (isStart ? token.compareTo(this.end) < 0 : token.compareTo(this.end) <= 0) ? true : (isBeforeEnd = false);
        return this.isWrappedAround() ? isAfterStart || isBeforeEnd : isAfterStart && isBeforeEnd;
    }

    public TokenRange mergeWith(TokenRange that) {
        boolean thatStartsInThis;
        if (this.equals(that)) {
            return this;
        }
        if (!(this.intersects(that) || this.end.equals(that.start) || that.end.equals(this.start))) {
            throw new IllegalArgumentException(String.format("Can't merge %s with %s because they neither intersect nor are adjacent", this, that));
        }
        if (this.isEmpty()) {
            return that;
        }
        if (that.isEmpty()) {
            return this;
        }
        boolean thisStartsInThat = that.contains(this.start, true) || this.start.equals(that.end);
        boolean bl = thatStartsInThis = this.contains(that.start, true) || that.start.equals(this.end);
        if (thisStartsInThat && thatStartsInThis) {
            return this.fullRing();
        }
        Token mergedEnd = thatStartsInThis && !this.contains(that.end, false) ? that.end : this.end;
        Token mergedStart = thisStartsInThat ? that.start : this.start;
        return new TokenRange(mergedStart, mergedEnd, this.factory);
    }

    private TokenRange fullRing() {
        return new TokenRange(this.factory.minToken(), this.factory.minToken(), this.factory);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TokenRange) {
            TokenRange that = (TokenRange)other;
            return Objects.equal(this.start, that.start) && Objects.equal(this.end, that.end);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.start, this.end);
    }

    public String toString() {
        return String.format("]%s, %s]", this.start, this.end);
    }

    @Override
    public int compareTo(TokenRange other) {
        if (this.equals(other)) {
            return 0;
        }
        int compareStart = this.start.compareTo(other.start);
        return compareStart != 0 ? compareStart : this.end.compareTo(other.end);
    }
}

