/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.TreeSet;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.cache.RowCacheSentinel;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.StorageHook;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.partitions.AbstractBTreePartition;
import org.apache.cassandra.db.partitions.CachedBTreePartition;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.partitions.ImmutableBTreePartition;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.SingletonUnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.LazilyInitializedUnfilteredRowIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIteratorWithLowerBound;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.pager.MultiPartitionPager;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.SinglePartitionPager;
import org.apache.cassandra.thrift.ThriftResultsMerger;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.SearchIterator;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.apache.cassandra.utils.concurrent.OpOrder;

public class SinglePartitionReadCommand
extends ReadCommand {
    protected static final ReadCommand.SelectionDeserializer selectionDeserializer = new Deserializer();
    private final DecoratedKey partitionKey;
    private final ClusteringIndexFilter clusteringIndexFilter;
    private int oldestUnrepairedTombstone = Integer.MAX_VALUE;

    public SinglePartitionReadCommand(boolean isDigest, int digestVersion, boolean isForThrift, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter) {
        super(ReadCommand.Kind.SINGLE_PARTITION, isDigest, digestVersion, isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits);
        assert (partitionKey.getPartitioner() == metadata.partitioner);
        this.partitionKey = partitionKey;
        this.clusteringIndexFilter = clusteringIndexFilter;
    }

    public static SinglePartitionReadCommand create(CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter) {
        return SinglePartitionReadCommand.create(false, metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter);
    }

    public static SinglePartitionReadCommand create(boolean isForThrift, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter) {
        return new SinglePartitionReadCommand(false, 0, isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter);
    }

    public static SinglePartitionReadCommand create(CFMetaData metadata, int nowInSec, DecoratedKey key, ColumnFilter columnFilter, ClusteringIndexFilter filter) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, columnFilter, RowFilter.NONE, DataLimits.NONE, key, filter);
    }

    public static SinglePartitionReadCommand fullPartitionRead(CFMetaData metadata, int nowInSec, DecoratedKey key) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, key, Slices.ALL);
    }

    public static SinglePartitionReadCommand fullPartitionRead(CFMetaData metadata, int nowInSec, ByteBuffer key) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, metadata.decorateKey(key), Slices.ALL);
    }

    public static SinglePartitionReadCommand create(CFMetaData metadata, int nowInSec, DecoratedKey key, Slice slice) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, key, Slices.with(metadata.comparator, slice));
    }

    public static SinglePartitionReadCommand create(CFMetaData metadata, int nowInSec, DecoratedKey key, Slices slices) {
        ClusteringIndexSliceFilter filter = new ClusteringIndexSliceFilter(slices, false);
        return SinglePartitionReadCommand.create(metadata, nowInSec, ColumnFilter.all(metadata), RowFilter.NONE, DataLimits.NONE, key, filter);
    }

    public static SinglePartitionReadCommand create(CFMetaData metadata, int nowInSec, ByteBuffer key, Slices slices) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, metadata.decorateKey(key), slices);
    }

    @Override
    public SinglePartitionReadCommand copy() {
        return new SinglePartitionReadCommand(this.isDigestQuery(), this.digestVersion(), this.isForThrift(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.partitionKey(), this.clusteringIndexFilter());
    }

    public DecoratedKey partitionKey() {
        return this.partitionKey;
    }

    public ClusteringIndexFilter clusteringIndexFilter() {
        return this.clusteringIndexFilter;
    }

    @Override
    public ClusteringIndexFilter clusteringIndexFilter(DecoratedKey key) {
        return this.clusteringIndexFilter;
    }

    @Override
    public long getTimeout() {
        return DatabaseDescriptor.getReadRpcTimeout();
    }

    @Override
    public boolean selectsKey(DecoratedKey key) {
        if (!this.partitionKey().equals(key)) {
            return false;
        }
        return this.rowFilter().partitionKeyRestrictionsAreSatisfiedBy(key, this.metadata().getKeyValidator());
    }

    @Override
    public boolean selectsClustering(DecoratedKey key, Clustering clustering) {
        if (clustering == Clustering.STATIC_CLUSTERING) {
            return !this.columnFilter().fetchedColumns().statics.isEmpty();
        }
        if (!this.clusteringIndexFilter().selects(clustering)) {
            return false;
        }
        return this.rowFilter().clusteringKeyRestrictionsAreSatisfiedBy(clustering);
    }

    public SinglePartitionReadCommand forPaging(Clustering lastReturned, int pageSize) {
        assert (!this.isDigestQuery());
        return SinglePartitionReadCommand.create(this.isForThrift(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits().forPaging(pageSize), this.partitionKey(), lastReturned == null ? this.clusteringIndexFilter() : this.clusteringIndexFilter.forPaging(this.metadata().comparator, lastReturned, false));
    }

    @Override
    public PartitionIterator execute(ConsistencyLevel consistency, ClientState clientState) throws RequestExecutionException {
        return StorageProxy.read(Group.one(this), consistency, clientState);
    }

    @Override
    public SinglePartitionPager getPager(PagingState pagingState, int protocolVersion) {
        return SinglePartitionReadCommand.getPager(this, pagingState, protocolVersion);
    }

    private static SinglePartitionPager getPager(SinglePartitionReadCommand command, PagingState pagingState, int protocolVersion) {
        return new SinglePartitionPager(command, pagingState, protocolVersion);
    }

    @Override
    protected void recordLatency(TableMetrics metric, long latencyNanos) {
        metric.readLatency.addNano(latencyNanos);
    }

    @Override
    protected UnfilteredPartitionIterator queryStorage(ColumnFamilyStore cfs, ReadExecutionController executionController) {
        UnfilteredRowIterator partition = cfs.isRowCacheEnabled() ? this.getThroughCache(cfs, executionController) : this.queryMemtableAndDisk(cfs, executionController);
        return new SingletonUnfilteredPartitionIterator(partition, this.isForThrift());
    }

    private UnfilteredRowIterator getThroughCache(ColumnFamilyStore cfs, ReadExecutionController executionController) {
        assert (!cfs.isIndex());
        assert (cfs.isRowCacheEnabled()) : String.format("Row cache is not enabled on table [%s]", cfs.name);
        RowCacheKey key = new RowCacheKey(this.metadata().ksAndCFName, this.partitionKey());
        IRowCacheEntry cached = (IRowCacheEntry)CacheService.instance.rowCache.get(key);
        if (cached != null) {
            if (cached instanceof RowCacheSentinel) {
                Tracing.trace("Row cache miss (race)");
                cfs.metric.rowCacheMiss.inc();
                return this.queryMemtableAndDisk(cfs, executionController);
            }
            CachedPartition cachedPartition = (CachedPartition)cached;
            if (cfs.isFilterFullyCoveredBy(this.clusteringIndexFilter(), this.limits(), cachedPartition, this.nowInSec())) {
                cfs.metric.rowCacheHit.inc();
                Tracing.trace("Row cache hit");
                UnfilteredRowIterator unfilteredRowIterator = this.clusteringIndexFilter().getUnfilteredRowIterator(this.columnFilter(), cachedPartition);
                cfs.metric.updateSSTableIterated(0);
                return unfilteredRowIterator;
            }
            cfs.metric.rowCacheHitOutOfRange.inc();
            Tracing.trace("Ignoring row cache as cached value could not satisfy query");
            return this.queryMemtableAndDisk(cfs, executionController);
        }
        cfs.metric.rowCacheMiss.inc();
        Tracing.trace("Row cache miss");
        boolean cacheFullPartitions = this.metadata().params.caching.cacheAllRows();
        if (cacheFullPartitions || this.clusteringIndexFilter().isHeadFilter()) {
            RowCacheSentinel sentinel = new RowCacheSentinel();
            boolean sentinelSuccess = CacheService.instance.rowCache.putIfAbsent(key, sentinel);
            boolean sentinelReplaced = false;
            try {
                UnfilteredRowIterator cacheIterator;
                UnfilteredRowIterator iter2;
                block16: {
                    int rowsToCache = this.metadata().params.caching.rowsPerPartitionToCache();
                    iter2 = SinglePartitionReadCommand.fullPartitionRead(this.metadata(), this.nowInSec(), this.partitionKey()).queryMemtableAndDisk(cfs, executionController);
                    try {
                        CachedBTreePartition toCache = CachedBTreePartition.create(DataLimits.cqlLimits(rowsToCache).filter(iter2, this.nowInSec()), this.nowInSec());
                        if (sentinelSuccess && !toCache.isEmpty()) {
                            Tracing.trace("Caching {} rows", (Object)toCache.rowCount());
                            CacheService.instance.rowCache.replace(key, sentinel, toCache);
                            sentinelReplaced = true;
                        }
                        cacheIterator = this.clusteringIndexFilter().getUnfilteredRowIterator(this.columnFilter(), toCache);
                        if (!cacheFullPartitions) break block16;
                        assert (!iter2.hasNext());
                        iter2.close();
                        UnfilteredRowIterator unfilteredRowIterator = cacheIterator;
                        return unfilteredRowIterator;
                    }
                    catch (Error | RuntimeException e) {
                        iter2.close();
                        throw e;
                    }
                }
                UnfilteredRowIterator unfilteredRowIterator = UnfilteredRowIterators.concat(cacheIterator, this.clusteringIndexFilter().filterNotIndexed(this.columnFilter(), iter2));
                return unfilteredRowIterator;
            }
            finally {
                if (sentinelSuccess && !sentinelReplaced) {
                    cfs.invalidateCachedPartition(key);
                }
            }
        }
        Tracing.trace("Fetching data but not populating cache as query does not query from the start of the partition");
        return this.queryMemtableAndDisk(cfs, executionController);
    }

    public UnfilteredRowIterator queryMemtableAndDisk(ColumnFamilyStore cfs, OpOrder.Group readOp) {
        return this.queryMemtableAndDisk(cfs, ReadExecutionController.forReadOp(readOp));
    }

    public UnfilteredRowIterator queryMemtableAndDisk(ColumnFamilyStore cfs, ReadExecutionController executionController) {
        Tracing.trace("Executing single-partition query on {}", (Object)cfs.name);
        return this.queryMemtableAndDiskInternal(cfs);
    }

    @Override
    protected int oldestUnrepairedTombstone() {
        return this.oldestUnrepairedTombstone;
    }

    private UnfilteredRowIterator queryMemtableAndDiskInternal(ColumnFamilyStore cfs) {
        if (this.clusteringIndexFilter() instanceof ClusteringIndexNamesFilter && this.queryNeitherCountersNorCollections()) {
            return this.queryMemtableAndSSTablesInTimestampOrder(cfs, (ClusteringIndexNamesFilter)this.clusteringIndexFilter());
        }
        Tracing.trace("Acquiring sstable references");
        ColumnFamilyStore.ViewFragment view = cfs.select(View.select(SSTableSet.LIVE, this.partitionKey()));
        ArrayList<UnfilteredRowIterator> iterators = new ArrayList<UnfilteredRowIterator>(Iterables.size(view.memtables) + view.sstables.size());
        ClusteringIndexFilter filter = this.clusteringIndexFilter();
        long minTimestamp = Long.MAX_VALUE;
        try {
            for (Memtable memtable : view.memtables) {
                Partition partition = memtable.getPartition(this.partitionKey());
                if (partition == null) continue;
                minTimestamp = Math.min(minTimestamp, memtable.getMinTimestamp());
                UnfilteredRowIterator iter2 = filter.getUnfilteredRowIterator(this.columnFilter(), partition);
                this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, partition.stats().minLocalDeletionTime);
                iterators.add(this.isForThrift() ? ThriftResultsMerger.maybeWrap(iter2, this.nowInSec()) : iter2);
            }
            Collections.sort(view.sstables, SSTableReader.maxTimestampComparator);
            long mostRecentPartitionTombstone = Long.MIN_VALUE;
            int nonIntersectingSSTables = 0;
            ArrayList<SSTableReader> skippedSSTablesWithTombstones = null;
            for (SSTableReader sstable : view.sstables) {
                if (sstable.getMaxTimestamp() < mostRecentPartitionTombstone) break;
                if (!this.shouldInclude(sstable)) {
                    ++nonIntersectingSSTables;
                    if (!sstable.hasTombstones()) continue;
                    if (skippedSSTablesWithTombstones == null) {
                        skippedSSTablesWithTombstones = new ArrayList<SSTableReader>();
                    }
                    skippedSSTablesWithTombstones.add(sstable);
                    continue;
                }
                minTimestamp = Math.min(minTimestamp, sstable.getMinTimestamp());
                UnfilteredRowIteratorWithLowerBound iter3 = this.makeIterator(cfs, sstable, true);
                if (!sstable.isRepaired()) {
                    this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, sstable.getMinLocalDeletionTime());
                }
                iterators.add(iter3);
                mostRecentPartitionTombstone = Math.max(mostRecentPartitionTombstone, iter3.partitionLevelDeletion().markedForDeleteAt());
            }
            int includedDueToTombstones = 0;
            if (skippedSSTablesWithTombstones != null) {
                for (SSTableReader sstable : skippedSSTablesWithTombstones) {
                    if (sstable.getMaxTimestamp() <= minTimestamp) continue;
                    UnfilteredRowIteratorWithLowerBound iter4 = this.makeIterator(cfs, sstable, false);
                    if (!sstable.isRepaired()) {
                        this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, sstable.getMinLocalDeletionTime());
                    }
                    iterators.add(iter4);
                    ++includedDueToTombstones;
                }
            }
            if (Tracing.isTracing()) {
                Tracing.trace("Skipped {}/{} non-slice-intersecting sstables, included {} due to tombstones", nonIntersectingSSTables, view.sstables.size(), includedDueToTombstones);
            }
            if (iterators.isEmpty()) {
                return EmptyIterators.unfilteredRow(cfs.metadata, this.partitionKey(), filter.isReversed());
            }
            StorageHook.instance.reportRead(cfs.metadata.cfId, this.partitionKey());
            return this.withStateTracking(this.withSSTablesIterated(iterators, cfs.metric));
        }
        catch (Error | RuntimeException e) {
            try {
                FBUtilities.closeAll(iterators);
            }
            catch (Exception suppressed) {
                e.addSuppressed(suppressed);
            }
            throw e;
        }
    }

    private boolean shouldInclude(SSTableReader sstable) {
        if (!this.columnFilter().fetchedColumns().statics.isEmpty()) {
            return true;
        }
        return this.clusteringIndexFilter().shouldInclude(sstable);
    }

    private UnfilteredRowIteratorWithLowerBound makeIterator(ColumnFamilyStore cfs, SSTableReader sstable, boolean applyThriftTransformation) {
        return StorageHook.instance.makeRowIteratorWithLowerBound(cfs, this.partitionKey(), sstable, this.clusteringIndexFilter(), this.columnFilter(), this.isForThrift(), this.nowInSec(), applyThriftTransformation);
    }

    private UnfilteredRowIterator withSSTablesIterated(final List<UnfilteredRowIterator> iterators, final TableMetrics metrics) {
        UnfilteredRowIterator merged = UnfilteredRowIterators.merge(iterators, this.nowInSec());
        if (!merged.isEmpty()) {
            DecoratedKey key = merged.partitionKey();
            metrics.samplers.get((Object)TableMetrics.Sampler.READS).addSample(key.getKey(), key.hashCode(), 1);
        }
        class UpdateSstablesIterated
        extends Transformation {
            UpdateSstablesIterated() {
            }

            @Override
            public void onPartitionClose() {
                int sstablesIterated = (int)iterators.stream().filter(it -> it instanceof LazilyInitializedUnfilteredRowIterator).filter(it -> ((LazilyInitializedUnfilteredRowIterator)it).initialized()).count();
                metrics.updateSSTableIterated(sstablesIterated);
                Tracing.trace("Merged data from memtables and {} sstables", (Object)sstablesIterated);
            }
        }
        return Transformation.apply(merged, new UpdateSstablesIterated());
    }

    private boolean queryNeitherCountersNorCollections() {
        for (ColumnDefinition column : this.columnFilter().fetchedColumns()) {
            if (!column.type.isCollection() && !column.type.isCounter()) continue;
            return false;
        }
        return true;
    }

    private UnfilteredRowIterator queryMemtableAndSSTablesInTimestampOrder(ColumnFamilyStore cfs, ClusteringIndexNamesFilter filter) {
        UnfilteredRowIterator iter2;
        Tracing.trace("Acquiring sstable references");
        ColumnFamilyStore.ViewFragment view = cfs.select(View.select(SSTableSet.LIVE, this.partitionKey()));
        AbstractBTreePartition result = null;
        Tracing.trace("Merging memtable contents");
        for (Memtable memtable : view.memtables) {
            Partition partition = memtable.getPartition(this.partitionKey());
            if (partition == null) continue;
            iter2 = filter.getUnfilteredRowIterator(this.columnFilter(), partition);
            Throwable throwable = null;
            try {
                if (iter2.isEmpty()) continue;
                result = this.add(this.isForThrift() ? ThriftResultsMerger.maybeWrap(iter2, this.nowInSec()) : iter2, (ImmutableBTreePartition)result, filter, false);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (iter2 == null) continue;
                if (throwable != null) {
                    try {
                        iter2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                iter2.close();
            }
        }
        Collections.sort(view.sstables, SSTableReader.maxTimestampComparator);
        int sstablesIterated = 0;
        boolean onlyUnrepaired = true;
        for (SSTableReader sstable : view.sstables) {
            Throwable throwable;
            UnfilteredRowIterator iter3;
            long currentMaxTs;
            if (result != null && sstable.getMaxTimestamp() < result.partitionLevelDeletion().markedForDeleteAt() || (filter = this.reduceFilter(filter, result, currentMaxTs = sstable.getMaxTimestamp())) == null) break;
            if (!this.shouldInclude(sstable)) {
                if (!sstable.hasTombstones()) continue;
                sstable.incrementReadCount();
                iter3 = StorageHook.instance.makeRowIterator(cfs, sstable, this.partitionKey(), Slices.ALL, this.columnFilter(), filter.isReversed(), this.isForThrift());
                throwable = null;
                try {
                    if (!iter3.partitionLevelDeletion().isLive()) continue;
                    ++sstablesIterated;
                    result = this.add(UnfilteredRowIterators.noRowsIterator(iter3.metadata(), iter3.partitionKey(), Rows.EMPTY_STATIC_ROW, iter3.partitionLevelDeletion(), filter.isReversed()), (ImmutableBTreePartition)result, filter, sstable.isRepaired());
                    continue;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (iter3 == null) continue;
                    if (throwable != null) {
                        try {
                            iter3.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    iter3.close();
                    continue;
                }
            }
            Tracing.trace("Merging data from sstable {}", (Object)sstable.descriptor.generation);
            sstable.incrementReadCount();
            iter3 = StorageHook.instance.makeRowIterator(cfs, sstable, this.partitionKey(), filter.getSlices(this.metadata()), this.columnFilter(), filter.isReversed(), this.isForThrift());
            throwable = null;
            try {
                if (iter3.isEmpty()) continue;
                if (sstable.isRepaired()) {
                    onlyUnrepaired = false;
                }
                ++sstablesIterated;
                result = this.add(this.isForThrift() ? ThriftResultsMerger.maybeWrap(iter3, this.nowInSec()) : iter3, (ImmutableBTreePartition)result, filter, sstable.isRepaired());
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (iter3 == null) continue;
                if (throwable != null) {
                    try {
                        iter3.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                    continue;
                }
                iter3.close();
            }
        }
        cfs.metric.updateSSTableIterated(sstablesIterated);
        if (result == null || result.isEmpty()) {
            return EmptyIterators.unfilteredRow(this.metadata(), this.partitionKey(), false);
        }
        DecoratedKey key = result.partitionKey();
        cfs.metric.samplers.get((Object)TableMetrics.Sampler.READS).addSample(key.getKey(), key.hashCode(), 1);
        StorageHook.instance.reportRead(cfs.metadata.cfId, this.partitionKey());
        if (sstablesIterated > cfs.getMinimumCompactionThreshold() && onlyUnrepaired && !cfs.isAutoCompactionDisabled() && cfs.getCompactionStrategyManager().shouldDefragment()) {
            Tracing.trace("Defragmenting requested data");
            iter2 = result.unfilteredIterator(this.columnFilter(), Slices.ALL, false);
            Throwable throwable = null;
            try {
                Mutation mutation = new Mutation(PartitionUpdate.fromIterator(iter2, this.columnFilter()));
                StageManager.getStage(Stage.MUTATION).execute(() -> Keyspace.open(mutation.getKeyspaceName()).apply(mutation, false, false));
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (iter2 != null) {
                    if (throwable != null) {
                        try {
                            iter2.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        iter2.close();
                    }
                }
            }
        }
        return this.withStateTracking(result.unfilteredIterator(this.columnFilter(), Slices.ALL, this.clusteringIndexFilter().isReversed()));
    }

    private ImmutableBTreePartition add(UnfilteredRowIterator iter2, ImmutableBTreePartition result, ClusteringIndexNamesFilter filter, boolean isRepaired) {
        if (!isRepaired) {
            this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, iter2.stats().minLocalDeletionTime);
        }
        int maxRows = Math.max(filter.requestedRows().size(), 1);
        if (result == null) {
            return ImmutableBTreePartition.create(iter2, maxRows);
        }
        try (UnfilteredRowIterator merged = UnfilteredRowIterators.merge(Arrays.asList(iter2, result.unfilteredIterator(this.columnFilter(), Slices.ALL, filter.isReversed())), this.nowInSec());){
            ImmutableBTreePartition immutableBTreePartition = ImmutableBTreePartition.create(merged, maxRows);
            return immutableBTreePartition;
        }
    }

    private ClusteringIndexNamesFilter reduceFilter(ClusteringIndexNamesFilter filter, Partition result, long sstableTimestamp) {
        boolean hasNoMoreClusterings;
        if (result == null) {
            return filter;
        }
        SearchIterator<Clustering, Row> searchIter = result.searchIterator(this.columnFilter(), false);
        PartitionColumns columns = this.columnFilter().fetchedColumns();
        NavigableSet<Clustering> clusterings = filter.requestedRows();
        boolean removeStatic = false;
        if (!columns.statics.isEmpty()) {
            Row staticRow = searchIter.next(Clustering.STATIC_CLUSTERING);
            removeStatic = staticRow != null && this.canRemoveRow(staticRow, columns.statics, sstableTimestamp);
        }
        TreeSet<Clusterable> toRemove = null;
        for (Clustering clustering : clusterings) {
            if (!searchIter.hasNext()) break;
            Row row = searchIter.next(clustering);
            if (row == null || !this.canRemoveRow(row, columns.regulars, sstableTimestamp)) continue;
            if (toRemove == null) {
                toRemove = new TreeSet<Clusterable>(result.metadata().comparator);
            }
            toRemove.add(clustering);
        }
        if (!removeStatic && toRemove == null) {
            return filter;
        }
        boolean hasNoMoreStatic = columns.statics.isEmpty() || removeStatic;
        boolean bl = hasNoMoreClusterings = clusterings.isEmpty() || toRemove != null && toRemove.size() == clusterings.size();
        if (hasNoMoreStatic && hasNoMoreClusterings) {
            return null;
        }
        if (toRemove != null) {
            BTreeSet.Builder<Clusterable> newClusterings = BTreeSet.builder(result.metadata().comparator);
            newClusterings.addAll(Sets.difference(clusterings, toRemove));
            clusterings = newClusterings.build();
        }
        return new ClusteringIndexNamesFilter(clusterings, filter.isReversed());
    }

    private boolean canRemoveRow(Row row, Columns requestedColumns, long sstableTimestamp) {
        if (row.primaryKeyLivenessInfo().isEmpty() || row.primaryKeyLivenessInfo().timestamp() <= sstableTimestamp) {
            return false;
        }
        for (ColumnDefinition column : requestedColumns) {
            Cell cell = row.getCell(column);
            if (cell != null && cell.timestamp() > sstableTimestamp) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return String.format("Read(%s.%s columns=%s rowFilter=%s limits=%s key=%s filter=%s, nowInSec=%d)", this.metadata().ksName, this.metadata().cfName, this.columnFilter(), this.rowFilter(), this.limits(), this.metadata().getKeyValidator().getString(this.partitionKey().getKey()), this.clusteringIndexFilter.toString(this.metadata()), this.nowInSec());
    }

    @Override
    public MessageOut<ReadCommand> createMessage(int version) {
        return new MessageOut<ReadCommand>(MessagingService.Verb.READ, this, version < 10 ? legacyReadCommandSerializer : serializer);
    }

    @Override
    protected void appendCQLWhereClause(StringBuilder sb) {
        String filterString;
        sb.append(" WHERE ");
        sb.append(ColumnDefinition.toCQLString(this.metadata().partitionKeyColumns())).append(" = ");
        DataRange.appendKeyString(sb, this.metadata().getKeyValidator(), this.partitionKey().getKey());
        if (!this.rowFilter().isEmpty()) {
            sb.append(" AND ").append(this.rowFilter());
        }
        if (!(filterString = this.clusteringIndexFilter().toCQLString(this.metadata())).isEmpty()) {
            sb.append(" AND ").append(filterString);
        }
    }

    @Override
    protected void serializeSelection(DataOutputPlus out, int version) throws IOException {
        this.metadata().getKeyValidator().writeValue(this.partitionKey().getKey(), out);
        ClusteringIndexFilter.serializer.serialize(this.clusteringIndexFilter(), out, version);
    }

    @Override
    protected long selectionSerializedSize(int version) {
        return this.metadata().getKeyValidator().writtenLength(this.partitionKey().getKey()) + ClusteringIndexFilter.serializer.serializedSize(this.clusteringIndexFilter(), version);
    }

    private static class Deserializer
    extends ReadCommand.SelectionDeserializer {
        private Deserializer() {
        }

        @Override
        public ReadCommand deserialize(DataInputPlus in, int version, boolean isDigest, int digestVersion, boolean isForThrift, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, Optional<IndexMetadata> index) throws IOException {
            DecoratedKey key = metadata.decorateKey(metadata.getKeyValidator().readValue(in));
            ClusteringIndexFilter filter = ClusteringIndexFilter.serializer.deserialize(in, version, metadata);
            return new SinglePartitionReadCommand(isDigest, digestVersion, isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits, key, filter);
        }
    }

    public static class Group
    implements ReadQuery {
        public final List<SinglePartitionReadCommand> commands;
        private final DataLimits limits;
        private final int nowInSec;

        public Group(List<SinglePartitionReadCommand> commands, DataLimits limits) {
            assert (!commands.isEmpty());
            this.commands = commands;
            this.limits = limits;
            this.nowInSec = commands.get(0).nowInSec();
            for (int i = 1; i < commands.size(); ++i) {
                assert (commands.get(i).nowInSec() == this.nowInSec);
            }
        }

        public static Group one(SinglePartitionReadCommand command) {
            return new Group(Collections.singletonList(command), command.limits());
        }

        @Override
        public PartitionIterator execute(ConsistencyLevel consistency, ClientState clientState) throws RequestExecutionException {
            return StorageProxy.read(this, consistency, clientState);
        }

        public int nowInSec() {
            return this.nowInSec;
        }

        @Override
        public DataLimits limits() {
            return this.limits;
        }

        public CFMetaData metadata() {
            return this.commands.get(0).metadata();
        }

        @Override
        public ReadExecutionController executionController() {
            return this.commands.get(0).executionController();
        }

        @Override
        public PartitionIterator executeInternal(ReadExecutionController controller) {
            ArrayList<PartitionIterator> partitions = new ArrayList<PartitionIterator>(this.commands.size());
            for (SinglePartitionReadCommand cmd : this.commands) {
                partitions.add(cmd.executeInternal(controller));
            }
            return this.limits.filter(PartitionIterators.concat(partitions), this.nowInSec);
        }

        @Override
        public QueryPager getPager(PagingState pagingState, int protocolVersion) {
            if (this.commands.size() == 1) {
                return SinglePartitionReadCommand.getPager(this.commands.get(0), pagingState, protocolVersion);
            }
            return new MultiPartitionPager(this, pagingState, protocolVersion);
        }

        @Override
        public boolean selectsKey(DecoratedKey key) {
            return Iterables.any(this.commands, c -> c.selectsKey(key));
        }

        @Override
        public boolean selectsClustering(DecoratedKey key, Clustering clustering) {
            return Iterables.any(this.commands, c -> c.selectsClustering(key, clustering));
        }

        public String toString() {
            return this.commands.toString();
        }
    }
}

