/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.transform;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.cassandra.db.transform.MoreContents;
import org.apache.cassandra.db.transform.Stack;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.Throwables;

abstract class BaseIterator<V, I extends CloseableIterator<? extends V>, O extends V>
extends Stack
implements AutoCloseable,
Iterator<O> {
    I input;
    V next;
    Stop stop;

    BaseIterator(BaseIterator<? extends V, ? extends I, ?> copyFrom) {
        super(copyFrom);
        this.input = copyFrom.input;
        this.next = copyFrom.next;
        this.stop = copyFrom.stop;
    }

    BaseIterator(I input) {
        this.input = input;
        this.stop = new Stop();
    }

    protected abstract Throwable runOnClose(int var1);

    protected abstract V applyOne(V var1, Transformation var2);

    @Override
    public final void close() {
        Throwable fail = this.runOnClose(this.length);
        if (this.next instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.next).close();
            }
            catch (Throwable t) {
                fail = Throwables.merge(fail, t);
            }
        }
        try {
            this.input.close();
        }
        catch (Throwable t) {
            fail = Throwables.merge(fail, t);
        }
        Throwables.maybeFail(fail);
    }

    @Override
    public final O next() {
        if (this.next == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        V next = this.next;
        this.next = null;
        return (O)next;
    }

    protected final boolean hasMoreContents() {
        return this.moreContents.length > 0 && this.tryGetMoreContents();
    }

    private boolean tryGetMoreContents() {
        for (int i = 0; i < this.moreContents.length; ++i) {
            Stack.MoreContentsHolder holder = this.moreContents[i];
            MoreContents provider = holder.moreContents;
            CloseableIterator newContents = (CloseableIterator)provider.moreContents();
            if (newContents == null) continue;
            this.input.close();
            this.input = newContents;
            Stack prefix = EMPTY;
            if (newContents instanceof BaseIterator) {
                BaseIterator abstr = (BaseIterator)((Object)newContents);
                prefix = abstr;
                this.input = abstr.input;
                this.next = this.apply(abstr.next, holder.length);
            }
            Throwables.maybeFail(this.runOnClose(holder.length));
            this.refill(prefix, holder, i);
            if (this.next != null || this.input.hasNext()) {
                return true;
            }
            i = -1;
        }
        return false;
    }

    private V apply(V next, int from) {
        while (next != null & from < this.length) {
            next = this.applyOne(next, this.stack[from++]);
        }
        return next;
    }

    static class Stop {
        boolean isSignalled;

        Stop() {
        }
    }
}

