/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.partitions.FilteredPartition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.view.TemporalRow;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.pager.SinglePartitionPager;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewBuilder
extends CompactionInfo.Holder {
    private final ColumnFamilyStore baseCfs;
    private final View view;
    private final UUID compactionId;
    private volatile Token prevToken = null;
    private static final Logger logger = LoggerFactory.getLogger(ViewBuilder.class);
    private volatile boolean isStopped = false;

    public ViewBuilder(ColumnFamilyStore baseCfs, View view) {
        this.baseCfs = baseCfs;
        this.view = view;
        this.compactionId = UUIDGen.getTimeUUID();
    }

    private void buildKey(DecoratedKey key) {
        AtomicLong noBase = new AtomicLong(Long.MAX_VALUE);
        ReadQuery selectQuery = this.view.getReadQuery();
        if (!selectQuery.selectsKey(key)) {
            return;
        }
        SinglePartitionPager pager = this.view.getSelectStatement().internalReadForView(key, FBUtilities.nowInSeconds()).getPager(null, 4);
        while (!pager.isExhausted()) {
            ReadExecutionController executionController = pager.executionController();
            Throwable throwable = null;
            try {
                PartitionIterator partitionIterator = pager.fetchPageInternal(128, executionController);
                Throwable throwable2 = null;
                try {
                    if (!partitionIterator.hasNext()) {
                        return;
                    }
                    RowIterator rowIterator = (RowIterator)partitionIterator.next();
                    Throwable throwable3 = null;
                    try {
                        TemporalRow.Set temporalRows;
                        FilteredPartition partition = FilteredPartition.create(rowIterator);
                        Collection<Mutation> mutations = this.view.createMutations(partition, temporalRows = this.view.getTemporalRowSet(partition, null, true), true);
                        if (mutations == null) continue;
                        StorageProxy.mutateMV(key.getKey(), mutations, true, noBase);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (rowIterator == null) continue;
                        if (throwable3 != null) {
                            try {
                                rowIterator.close();
                            }
                            catch (Throwable throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        rowIterator.close();
                    }
                }
                catch (Throwable throwable6) {
                    throwable2 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (partitionIterator == null) continue;
                    if (throwable2 != null) {
                        try {
                            partitionIterator.close();
                        }
                        catch (Throwable throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    partitionIterator.close();
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (executionController == null) continue;
                if (throwable != null) {
                    try {
                        executionController.close();
                    }
                    catch (Throwable throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                    continue;
                }
                executionController.close();
            }
        }
    }

    public void run() {
        Token lastToken;
        Object object;
        Object temp;
        Function<org.apache.cassandra.db.lifecycle.View, Iterable<SSTableReader>> function;
        String ksname = this.baseCfs.metadata.ksName;
        String viewName = this.view.name;
        if (SystemKeyspace.isViewBuilt(ksname, viewName)) {
            return;
        }
        Collection<Range<Token>> ranges = StorageService.instance.getLocalRanges(this.baseCfs.metadata.ksName);
        final Pair<Integer, Token> buildStatus = SystemKeyspace.getViewBuildStatus(ksname, viewName);
        if (buildStatus == null) {
            this.baseCfs.forceBlockingFlush();
            function = org.apache.cassandra.db.lifecycle.View.select(SSTableSet.CANONICAL);
            int generation = Integer.MIN_VALUE;
            temp = this.baseCfs.selectAndReference((Function<org.apache.cassandra.db.lifecycle.View, Iterable<SSTableReader>>)function).refs;
            Throwable throwable = null;
            try {
                object = ((Refs)temp).iterator();
                while (object.hasNext()) {
                    SSTableReader reader = object.next();
                    generation = Math.max(reader.descriptor.generation, generation);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (temp != null) {
                    if (throwable != null) {
                        try {
                            ((Refs)temp).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((Refs)temp).close();
                    }
                }
            }
            SystemKeyspace.beginViewBuild(ksname, viewName, generation);
            lastToken = null;
        } else {
            function = new Function<org.apache.cassandra.db.lifecycle.View, Iterable<SSTableReader>>(){

                @Override
                @Nullable
                public Iterable<SSTableReader> apply(org.apache.cassandra.db.lifecycle.View view) {
                    Iterable<SSTableReader> readers = org.apache.cassandra.db.lifecycle.View.select(SSTableSet.CANONICAL).apply(view);
                    if (readers != null) {
                        return Iterables.filter(readers, ssTableReader -> ssTableReader.descriptor.generation <= (Integer)pair.left);
                    }
                    return null;
                }
            };
            lastToken = (Token)buildStatus.right;
        }
        this.prevToken = lastToken;
        try {
            Refs<SSTableReader> sstables = this.baseCfs.selectAndReference((Function<org.apache.cassandra.db.lifecycle.View, Iterable<SSTableReader>>)function).refs;
            temp = null;
            try {
                ReducingKeyIterator iter2 = new ReducingKeyIterator(sstables);
                object = null;
                try {
                    while (!this.isStopped && iter2.hasNext()) {
                        DecoratedKey key = iter2.next();
                        Token token = key.getToken();
                        if (lastToken != null && lastToken.compareTo(token) >= 0) continue;
                        for (Range range : ranges) {
                            if (!range.contains(token)) continue;
                            this.buildKey(key);
                            if (this.prevToken != null && this.prevToken.compareTo(token) == 0) continue;
                            SystemKeyspace.updateViewBuildStatus(ksname, viewName, key.getToken());
                            this.prevToken = token;
                        }
                        lastToken = null;
                    }
                    if (!this.isStopped) {
                        SystemKeyspace.finishViewBuildStatus(ksname, viewName);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (iter2 != null) {
                        if (object != null) {
                            try {
                                iter2.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            iter2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                temp = throwable;
                throw throwable;
            }
            finally {
                if (sstables != null) {
                    if (temp != null) {
                        try {
                            sstables.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)temp).addSuppressed(throwable);
                        }
                    } else {
                        sstables.close();
                    }
                }
            }
        }
        catch (Exception e) {
            ViewBuilder builder = new ViewBuilder(this.baseCfs, this.view);
            ScheduledExecutors.nonPeriodicTasks.schedule(() -> CompactionManager.instance.submitViewBuilder(builder), 5L, TimeUnit.MINUTES);
            logger.warn("Materialized View failed to complete, sleeping 5 minutes before restarting", e);
        }
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        long rangesLeft = 0L;
        long rangesTotal = 0L;
        Token lastToken = this.prevToken;
        for (Range<Token> range : StorageService.instance.getLocalRanges(this.baseCfs.keyspace.getName())) {
            ++rangesLeft;
            ++rangesTotal;
            if (lastToken != null && !range.contains(lastToken)) continue;
            rangesLeft = 0L;
        }
        return new CompactionInfo(this.baseCfs.metadata, OperationType.VIEW_BUILD, rangesLeft, rangesTotal, "ranges", this.compactionId);
    }

    @Override
    public void stop() {
        this.isStopped = true;
    }
}

