/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.index.sasi.SSTableIndex;
import org.apache.cassandra.index.sasi.disk.Token;
import org.apache.cassandra.index.sasi.plan.Expression;
import org.apache.cassandra.index.sasi.utils.RangeIterator;
import org.apache.cassandra.index.sasi.utils.RangeUnionIterator;
import org.apache.cassandra.io.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermIterator
extends RangeIterator<Long, Token> {
    private static final Logger logger = LoggerFactory.getLogger(TermIterator.class);
    private static final ThreadLocal<ExecutorService> SEARCH_EXECUTOR = new ThreadLocal<ExecutorService>(){

        @Override
        public ExecutorService initialValue() {
            final String currentThread = Thread.currentThread().getName();
            int concurrencyFactor = DatabaseDescriptor.searchConcurrencyFactor();
            logger.info("Search Concurrency Factor is set to {} for {}", (Object)concurrencyFactor, (Object)currentThread);
            return concurrencyFactor <= 1 ? MoreExecutors.newDirectExecutorService() : Executors.newFixedThreadPool(concurrencyFactor, new ThreadFactory(){
                public final AtomicInteger count = new AtomicInteger();

                @Override
                public Thread newThread(Runnable task) {
                    return new Thread(task, currentThread + "-SEARCH-" + this.count.incrementAndGet()){
                        {
                            super(x0, x1);
                            this.setDaemon(true);
                        }
                    };
                }
            });
        }
    };
    private final Expression expression;
    private final RangeIterator<Long, Token> union;
    private final Set<SSTableIndex> referencedIndexes;

    private TermIterator(Expression e, RangeIterator<Long, Token> union, Set<SSTableIndex> referencedIndexes) {
        super(union.getMinimum(), union.getMaximum(), union.getCount());
        this.expression = e;
        this.union = union;
        this.referencedIndexes = referencedIndexes;
    }

    public static TermIterator build(Expression e, Set<SSTableIndex> perSSTableIndexes) {
        CopyOnWriteArrayList tokens = new CopyOnWriteArrayList();
        AtomicLong tokenCount = new AtomicLong(0L);
        RangeIterator<Long, Token> memtableIterator = e.index.searchMemtable(e);
        if (memtableIterator != null) {
            tokens.add(memtableIterator);
            tokenCount.addAndGet(memtableIterator.getCount());
        }
        CopyOnWriteArraySet<SSTableIndex> referencedIndexes = new CopyOnWriteArraySet<SSTableIndex>();
        try {
            CountDownLatch latch = new CountDownLatch(perSSTableIndexes.size());
            ExecutorService searchExecutor = SEARCH_EXECUTOR.get();
            for (SSTableIndex index : perSSTableIndexes) {
                if (!index.reference()) {
                    latch.countDown();
                    continue;
                }
                referencedIndexes.add(index);
                searchExecutor.submit(() -> {
                    try {
                        e.checkpoint();
                        RangeIterator<Long, Token> keyIterator = index.search(e);
                        if (keyIterator == null) {
                            TermIterator.releaseIndex(referencedIndexes, index);
                            return;
                        }
                        tokens.add(keyIterator);
                        tokenCount.getAndAdd(keyIterator.getCount());
                    }
                    catch (Throwable e1) {
                        TermIterator.releaseIndex(referencedIndexes, index);
                        if (logger.isDebugEnabled()) {
                            logger.debug(String.format("Failed search an index %s, skipping.", index.getPath()), e1);
                        }
                    }
                    finally {
                        latch.countDown();
                    }
                });
            }
            Uninterruptibles.awaitUninterruptibly(latch);
            e.checkpoint();
            RangeIterator<Long, Token> ranges = RangeUnionIterator.build(tokens);
            return ranges == null ? null : new TermIterator(e, ranges, referencedIndexes);
        }
        catch (Throwable ex) {
            referencedIndexes.forEach(TermIterator::releaseQuietly);
            throw ex;
        }
    }

    @Override
    protected Token computeNext() {
        try {
            Token token = this.union.hasNext() ? (Token)this.union.next() : (Token)this.endOfData();
            return token;
        }
        finally {
            this.expression.checkpoint();
        }
    }

    @Override
    protected void performSkipTo(Long nextToken) {
        try {
            this.union.skipTo(nextToken);
        }
        finally {
            this.expression.checkpoint();
        }
    }

    @Override
    public void close() {
        FileUtils.closeQuietly(this.union);
        this.referencedIndexes.forEach(TermIterator::releaseQuietly);
        this.referencedIndexes.clear();
    }

    private static void releaseIndex(Set<SSTableIndex> indexes, SSTableIndex index) {
        indexes.remove(index);
        TermIterator.releaseQuietly(index);
    }

    private static void releaseQuietly(SSTableIndex index) {
        try {
            index.release();
        }
        catch (Throwable e) {
            logger.error(String.format("Failed to release index %s", index.getPath()), e);
        }
    }
}

