/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkTopologyStrategy
extends AbstractReplicationStrategy {
    private final Map<String, Integer> datacenters;
    private static final Logger logger = LoggerFactory.getLogger(NetworkTopologyStrategy.class);

    public NetworkTopologyStrategy(String keyspaceName, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> configOptions) throws ConfigurationException {
        super(keyspaceName, tokenMetadata, snitch, configOptions);
        HashMap<String, Integer> newDatacenters = new HashMap<String, Integer>();
        if (configOptions != null) {
            for (Map.Entry<String, String> entry : configOptions.entrySet()) {
                String dc = entry.getKey();
                if (dc.equalsIgnoreCase("replication_factor")) {
                    throw new ConfigurationException("replication_factor is an option for SimpleStrategy, not NetworkTopologyStrategy");
                }
                Integer replicas = Integer.valueOf(entry.getValue());
                newDatacenters.put(dc, replicas);
            }
        }
        this.datacenters = Collections.unmodifiableMap(newDatacenters);
        logger.trace("Configured datacenter replicas are {}", (Object)FBUtilities.toString(this.datacenters));
    }

    @Override
    public List<InetAddress> calculateNaturalEndpoints(Token searchToken, TokenMetadata tokenMetadata) {
        LinkedHashSet<InetAddress> replicas = new LinkedHashSet<InetAddress>();
        HashSet<Pair<String, String>> seenRacks = new HashSet<Pair<String, String>>();
        TokenMetadata.Topology topology = tokenMetadata.getTopology();
        Multimap<String, InetAddress> allEndpoints = topology.getDatacenterEndpoints();
        Map<String, Multimap<String, InetAddress>> racks = topology.getDatacenterRacks();
        assert (!allEndpoints.isEmpty() && !racks.isEmpty()) : "not aware of any cluster members";
        int dcsToFill = 0;
        HashMap<String, DatacenterEndpoints> dcs = new HashMap<String, DatacenterEndpoints>(this.datacenters.size() * 2);
        for (Map.Entry<String, Integer> en : this.datacenters.entrySet()) {
            String dc = en.getKey();
            int rf = en.getValue();
            int nodeCount = this.sizeOrZero(allEndpoints.get(dc));
            if (rf <= 0 || nodeCount <= 0) continue;
            DatacenterEndpoints dcEndpoints = new DatacenterEndpoints(rf, this.sizeOrZero(racks.get(dc)), nodeCount, replicas, seenRacks);
            dcs.put(dc, dcEndpoints);
            ++dcsToFill;
        }
        Iterator<Token> tokenIter = TokenMetadata.ringIterator(tokenMetadata.sortedTokens(), searchToken, false);
        while (dcsToFill > 0 && tokenIter.hasNext()) {
            Token next = tokenIter.next();
            InetAddress ep = tokenMetadata.getEndpoint(next);
            Pair<String, String> location = topology.getLocation(ep);
            DatacenterEndpoints dcEndpoints = (DatacenterEndpoints)dcs.get(location.left);
            if (dcEndpoints == null || !dcEndpoints.addEndpointAndCheckIfDone(ep, location)) continue;
            --dcsToFill;
        }
        return new ArrayList<InetAddress>(replicas);
    }

    private int sizeOrZero(Multimap<?, ?> collection) {
        return collection != null ? collection.asMap().size() : 0;
    }

    private int sizeOrZero(Collection<?> collection) {
        return collection != null ? collection.size() : 0;
    }

    @Override
    public int getReplicationFactor() {
        int total = 0;
        for (int repFactor : this.datacenters.values()) {
            total += repFactor;
        }
        return total;
    }

    public int getReplicationFactor(String dc) {
        Integer replicas = this.datacenters.get(dc);
        return replicas == null ? 0 : replicas;
    }

    public Set<String> getDatacenters() {
        return this.datacenters.keySet();
    }

    @Override
    public void validateOptions() throws ConfigurationException {
        for (Map.Entry e : this.configOptions.entrySet()) {
            if (((String)e.getKey()).equalsIgnoreCase("replication_factor")) {
                throw new ConfigurationException("replication_factor is an option for SimpleStrategy, not NetworkTopologyStrategy");
            }
            this.validateReplicationFactor((String)e.getValue());
        }
    }

    @Override
    public boolean hasSameSettings(AbstractReplicationStrategy other) {
        return super.hasSameSettings(other) && ((NetworkTopologyStrategy)other).datacenters.equals(this.datacenters);
    }

    private static final class DatacenterEndpoints {
        Set<InetAddress> endpoints;
        Set<Pair<String, String>> racks;
        int rfLeft;
        int acceptableRackRepeats;

        DatacenterEndpoints(int rf, int rackCount, int nodeCount, Set<InetAddress> endpoints, Set<Pair<String, String>> racks) {
            this.endpoints = endpoints;
            this.racks = racks;
            this.rfLeft = Math.min(rf, nodeCount);
            this.acceptableRackRepeats = rf - rackCount;
        }

        boolean addEndpointAndCheckIfDone(InetAddress ep, Pair<String, String> location) {
            if (this.done()) {
                return false;
            }
            if (this.racks.add(location)) {
                --this.rfLeft;
                boolean added = this.endpoints.add(ep);
                assert (added);
                return this.done();
            }
            if (this.acceptableRackRepeats <= 0) {
                return false;
            }
            if (!this.endpoints.add(ep)) {
                return false;
            }
            --this.acceptableRackRepeats;
            --this.rfLeft;
            return this.done();
        }

        boolean done() {
            assert (this.rfLeft >= 0);
            return this.rfLeft == 0;
        }
    }
}

