/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.jobs;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.scheduler.api.JobDetails;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.jboss.logging.Logger;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

public class DeleteTenant
implements Func1<JobDetails, Completable> {
    private static Logger logger = Logger.getLogger(DeleteTenant.class);
    public static final String JOB_NAME = "DELETE_TENANT";
    private RxSession session;
    private PreparedStatement deleteTenant;
    private PreparedStatement deleteData;
    private PreparedStatement deleteFromMetricsIndex;
    private PreparedStatement findTags;
    private PreparedStatement deleteTag;
    private PreparedStatement deleteRetentions;
    private MetricsService metricsService;

    public DeleteTenant(RxSession session, MetricsService metricsService) {
        this.session = session;
        this.metricsService = metricsService;
        this.deleteTenant = session.getSession().prepare("DELETE FROM tenants WHERE id = ?");
        this.deleteData = session.getSession().prepare("DELETE FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = 0");
        this.deleteFromMetricsIndex = session.getSession().prepare("DELETE FROM metrics_idx WHERE tenant_id = ? AND type = ?");
        this.findTags = session.getSession().prepare("SELECT DISTINCT tenant_id, tname FROM metrics_tags_idx");
        this.deleteTag = session.getSession().prepare("DELETE FROM metrics_tags_idx WHERE tenant_id = ? AND tname = ?");
        this.deleteRetentions = session.getSession().prepare("DELETE FROM retentions_idx WHERE tenant_id = ? AND type = ?");
    }

    public Completable call(JobDetails details) {
        String tenantId = details.getParameters().get("tenantId");
        return Completable.concat((Completable[])new Completable[]{this.deleteMetricData(tenantId).toCompletable().doOnCompleted(() -> logger.debug((Object)("Finished deleting metrics for " + tenantId))), this.deleteRetentions(tenantId).toCompletable().doOnCompleted(() -> logger.debug((Object)("Finished deleting retentions for " + tenantId))), this.deleteMetricsIndex(tenantId).toCompletable().doOnCompleted(() -> logger.debug((Object)"Finished updating metrics index")), this.deleteTags(tenantId).toCompletable().doOnCompleted(() -> logger.debug((Object)"Finished deleting metric tags")), this.deleteTenant(tenantId).toCompletable().doOnCompleted(() -> logger.debug((Object)("Finished updating tenants table for " + tenantId)))}).doOnCompleted(() -> logger.debug((Object)("Finished deleting " + tenantId)));
    }

    private Observable<ResultSet> deleteMetricData(String tenantId) {
        return Observable.from(MetricType.all()).flatMap(type -> this.metricsService.findMetrics(tenantId, type).flatMap(this::deleteMetricData));
    }

    private <T> Observable<ResultSet> deleteMetricData(Metric<T> metric) {
        return this.session.execute((Statement)this.deleteData.bind(metric.getMetricId().getTenantId(), metric.getMetricId().getType().getCode(), metric.getMetricId().getName()));
    }

    private Observable<ResultSet> deleteMetricsIndex(String tenantId) {
        return Observable.from(MetricType.all()).flatMap(type -> this.session.execute((Statement)this.deleteFromMetricsIndex.bind(tenantId, type.getCode())));
    }

    private Observable<ResultSet> deleteTags(String tenantId) {
        return this.session.execute((Statement)this.findTags.bind()).flatMap(Observable::from).filter(row -> row.getString(0).equals(tenantId)).flatMap(row -> this.session.execute((Statement)this.deleteTag.bind(row.getString(0), row.getString(1))));
    }

    private <T> Observable<ResultSet> deleteRetentions(String tenantId) {
        return Observable.from(MetricType.all()).flatMap(type -> this.session.execute((Statement)this.deleteRetentions.bind(tenantId, type.getCode())));
    }

    private Observable<ResultSet> deleteTenant(String tenantId) {
        return this.session.execute((Statement)this.deleteTenant.bind(tenantId));
    }
}

