/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.jobs;

import com.google.common.collect.ImmutableMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.core.jobs.DeleteTenant;
import org.hawkular.metrics.core.jobs.JobsService;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.scheduler.api.JobDetails;
import org.hawkular.metrics.scheduler.api.RetryPolicy;
import org.hawkular.metrics.scheduler.api.Scheduler;
import org.hawkular.metrics.scheduler.api.SingleExecutionTrigger;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.jboss.logging.Logger;
import org.joda.time.Minutes;
import rx.Single;
import rx.functions.Func2;

public class JobsServiceImpl
implements JobsService {
    private static Logger logger = Logger.getLogger(DeleteTenant.class);
    private Scheduler scheduler;
    private RxSession session;
    private MetricsService metricsService;
    private DeleteTenant deleteTenant;

    public void setMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    public void setSession(RxSession session) {
        this.session = session;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void start() {
        this.scheduler.start();
        this.deleteTenant = new DeleteTenant(this.session, this.metricsService);
        ConcurrentHashMap deleteTenantAttempts = new ConcurrentHashMap();
        Func2 deleteTenantRetryPolicy = (details, throwable) -> () -> {
            logger.warn((Object)("Execution of " + details + " failed"), throwable);
            logger.info((Object)(details + " will be retried in 5 minutes"));
            return Minutes.minutes(5).toStandardDuration().getMillis();
        };
        this.scheduler.register("DELETE_TENANT", this.deleteTenant, (Func2<JobDetails, Throwable, RetryPolicy>)deleteTenantRetryPolicy);
    }

    @Override
    public void shutdown() {
        this.scheduler.shutdown();
    }

    @Override
    public Single<JobDetails> submitDeleteTenantJob(String tenantId, String jobName) {
        return this.scheduler.scheduleJob("DELETE_TENANT", jobName, ImmutableMap.of("tenantId", tenantId), new SingleExecutionTrigger.Builder().withDelay(1L, TimeUnit.MINUTES).build());
    }
}

