/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import java.util.HashMap;
import java.util.Map;
import org.hawkular.metrics.model.AvailabilityBucketPoint;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.Buckets;
import org.hawkular.metrics.model.DataPoint;

final class AvailabilityDataPointCollector {
    private final Buckets buckets;
    private final long bucketStart;
    private DataPoint<AvailabilityType> previous;
    private Map<AvailabilityType, Long> durationMap;
    private long lastNotUptime;
    private long notUpCount;

    AvailabilityDataPointCollector(Buckets buckets, int bucketIndex) {
        this.buckets = buckets;
        this.bucketStart = buckets.getBucketStart(bucketIndex);
        this.durationMap = new HashMap<AvailabilityType, Long>();
    }

    void increment(DataPoint<AvailabilityType> dataPoint) {
        long timestamp = dataPoint.getTimestamp();
        AvailabilityType availType = dataPoint.getValue();
        if (this.previous != null && timestamp <= this.previous.getTimestamp()) {
            throw new IllegalStateException("Expected stream sorted in time ascending order");
        }
        if (this.previous == null) {
            Long availTypeDuration = this.durationMap.getOrDefault((Object)availType, 0L);
            availTypeDuration = availTypeDuration + (timestamp - this.bucketStart);
            this.durationMap.put(availType, availTypeDuration);
            if (availType != AvailabilityType.UP) {
                this.lastNotUptime = timestamp;
                ++this.notUpCount;
            }
        } else {
            Long previousAvailTypeDuration = this.durationMap.getOrDefault((Object)this.previous.getValue(), 0L);
            previousAvailTypeDuration = previousAvailTypeDuration + (timestamp - this.previous.getTimestamp());
            this.durationMap.put(this.previous.getValue(), previousAvailTypeDuration);
            if (availType == AvailabilityType.UP) {
                if (this.previous.getValue() != AvailabilityType.UP) {
                    this.lastNotUptime = timestamp;
                }
            } else {
                if (this.previous.getValue() == AvailabilityType.UP) {
                    ++this.notUpCount;
                }
                this.lastNotUptime = timestamp;
            }
        }
        this.previous = dataPoint;
    }

    AvailabilityBucketPoint toBucketPoint() {
        long to = this.bucketStart + this.buckets.getStep();
        Long availTypeDuration = this.durationMap.getOrDefault((Object)this.previous.getValue(), 0L);
        availTypeDuration = availTypeDuration + (to - this.previous.getTimestamp());
        this.durationMap.put(this.previous.getValue(), availTypeDuration);
        if (this.previous.getValue() != AvailabilityType.UP) {
            this.lastNotUptime = to;
        }
        return new AvailabilityBucketPoint.Builder(this.bucketStart, to).setDurationMap(this.durationMap).setLastNotUptime(this.lastNotUptime).setUptimeRatio((double)this.durationMap.getOrDefault((Object)AvailabilityType.UP, 0L).longValue() / (double)this.buckets.getStep()).setNotUptimeCount(this.notUpCount).build();
    }
}

