/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.BucketPoint;
import org.hawkular.metrics.model.Buckets;

public final class AvailabilityBucketPoint
extends BucketPoint {
    private final Map<AvailabilityType, Long> durationMap;
    private final Long lastNotUptime;
    private final Double uptimeRatio;
    private final Long notUpCount;
    @Deprecated
    private final Long downtimeDuration;
    @Deprecated
    private final Long lastDowntime;
    @Deprecated
    private final Long downtimeCount;

    @Deprecated
    protected AvailabilityBucketPoint(long start, long end, long downtimeDuration, long lastDowntime, double uptimeRatio, long downtimeCount) {
        super(start, end);
        this.durationMap = new HashMap<AvailabilityType, Long>();
        this.durationMap.put(AvailabilityType.DOWN, downtimeDuration);
        this.lastNotUptime = lastDowntime;
        this.uptimeRatio = this.getDoubleValue(uptimeRatio);
        this.notUpCount = downtimeCount;
        this.downtimeCount = downtimeCount;
        this.downtimeDuration = downtimeDuration;
        this.lastDowntime = lastDowntime;
    }

    @Deprecated
    public Long getDowntimeDuration() {
        return this.getDownDuration();
    }

    @Deprecated
    public Long getLastDowntime() {
        return this.getLastNotUptime();
    }

    @Deprecated
    public Long getDowntimeCount() {
        return this.getNotUpCount();
    }

    protected AvailabilityBucketPoint(long start, long end, Map<AvailabilityType, Long> durationMap, long lastNotUptime, double uptimeRatio, long notUpCount) {
        super(start, end);
        this.durationMap = durationMap;
        this.lastNotUptime = lastNotUptime;
        this.uptimeRatio = this.getDoubleValue(uptimeRatio);
        this.notUpCount = notUpCount;
        this.downtimeCount = notUpCount;
        this.downtimeDuration = this.getDownDuration();
        this.lastDowntime = lastNotUptime;
    }

    public Long getNotUpCount() {
        if (this.isEmpty()) {
            return null;
        }
        return this.notUpCount;
    }

    public Map<AvailabilityType, Long> getDurationMap() {
        return this.durationMap;
    }

    public Long getAdminDuration() {
        if (this.isEmpty()) {
            return null;
        }
        return this.durationMap.getOrDefault((Object)AvailabilityType.ADMIN, 0L);
    }

    public Long getDownDuration() {
        if (this.isEmpty()) {
            return null;
        }
        return this.durationMap.getOrDefault((Object)AvailabilityType.DOWN, 0L);
    }

    public Long getUnknownDuration() {
        if (this.isEmpty()) {
            return null;
        }
        return this.durationMap.getOrDefault((Object)AvailabilityType.UNKNOWN, 0L);
    }

    public Long getUpDuration() {
        if (this.isEmpty()) {
            return null;
        }
        return this.durationMap.getOrDefault((Object)AvailabilityType.UP, 0L);
    }

    public Long getNotUpDuration() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getAdminDuration() + this.getDownDuration() + this.getUnknownDuration();
    }

    public Long getLastNotUptime() {
        if (this.isEmpty()) {
            return null;
        }
        return this.lastNotUptime;
    }

    public Double getUptimeRatio() {
        return this.uptimeRatio;
    }

    @Override
    public boolean isEmpty() {
        return this.uptimeRatio == null;
    }

    public String toString() {
        return "AvailabilityBucketPoint [durationMap=" + this.durationMap + ", lastNotUptime=" + this.lastNotUptime + ", uptimeRatio=" + this.uptimeRatio + ", notUpCount=" + this.notUpCount + "]";
    }

    public static List<AvailabilityBucketPoint> toList(Map<Long, AvailabilityBucketPoint> pointMap, Buckets buckets) {
        return BucketPoint.toList(pointMap, buckets, (start, end) -> new Builder((long)start, (long)end).build());
    }

    public static class Builder {
        private final long start;
        private final long end;
        private Map<AvailabilityType, Long> durationMap = new HashMap<AvailabilityType, Long>();
        private long lastNotUptime = 0L;
        private double uptimeRatio = Double.NaN;
        private long notUpCount = 0L;

        public Builder(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public Builder setDurationMap(Map<AvailabilityType, Long> durationMap) {
            this.durationMap.putAll(durationMap);
            return this;
        }

        public Builder setAdminDuration(long adminDuration) {
            this.durationMap.put(AvailabilityType.ADMIN, adminDuration);
            return this;
        }

        public Builder setDownDuration(long downDuration) {
            this.durationMap.put(AvailabilityType.DOWN, downDuration);
            return this;
        }

        public Builder setUnknownDuration(long unknownDuration) {
            this.durationMap.put(AvailabilityType.UNKNOWN, unknownDuration);
            return this;
        }

        public Builder setUpDuration(long upDuration) {
            this.durationMap.put(AvailabilityType.UP, upDuration);
            return this;
        }

        public Builder setLastNotUptime(long lastNotUptime) {
            this.lastNotUptime = lastNotUptime;
            return this;
        }

        public Builder setUptimeRatio(double uptimeRatio) {
            this.uptimeRatio = uptimeRatio;
            return this;
        }

        public Builder setNotUptimeCount(long notUptimeCount) {
            this.notUpCount = notUptimeCount;
            return this;
        }

        public AvailabilityBucketPoint build() {
            return new AvailabilityBucketPoint(this.start, this.end, this.durationMap, this.lastNotUptime, this.uptimeRatio, this.notUpCount);
        }
    }
}

