/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;

public enum AvailabilityType {
    UP(0, "up"),
    DOWN(1, "down"),
    UNKNOWN(2, "unknown"),
    ADMIN(3, "admin");

    private byte code;
    private String text;

    private AvailabilityType(byte code, String text) {
        this.code = code;
        this.text = text;
    }

    public byte getCode() {
        return this.code;
    }

    public String getText() {
        return this.text;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("code", this.code).add("text", this.text).toString();
    }

    public static AvailabilityType fromString(String s) {
        switch (s.toLowerCase()) {
            case "up": {
                return UP;
            }
            case "down": {
                return DOWN;
            }
            case "unknown": {
                return UNKNOWN;
            }
            case "admin": {
                return ADMIN;
            }
        }
        throw new IllegalArgumentException(s + " is not a recognized availability type");
    }

    public static AvailabilityType fromBytes(ByteBuffer bytes) {
        switch (bytes.array()[bytes.position()]) {
            case 0: {
                return UP;
            }
            case 1: {
                return DOWN;
            }
            case 2: {
                return UNKNOWN;
            }
            case 3: {
                return ADMIN;
            }
        }
        throw new IllegalArgumentException(bytes.array()[0] + " is not a recognized availability type");
    }
}

