/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hawkular.metrics.model.BucketPoint;
import org.hawkular.metrics.model.Buckets;
import org.hawkular.metrics.model.Percentile;

public class NumericBucketPoint
extends BucketPoint {
    private final Double min;
    private final Double avg;
    private final Double median;
    private final Double max;
    private final Double sum;
    private Integer samples;
    private final List<Percentile> percentiles;

    private NumericBucketPoint(long start, long end, double min, double avg, double median, double max, double sum, List<Percentile> percentiles, int samples) {
        super(start, end);
        this.min = this.getDoubleValue(min);
        this.avg = this.getDoubleValue(avg);
        this.median = this.getDoubleValue(median);
        this.max = this.getDoubleValue(max);
        this.sum = this.getDoubleValue(sum);
        this.percentiles = percentiles;
        if (samples != 0) {
            this.samples = samples;
        }
    }

    public Double getMin() {
        return this.min;
    }

    public Double getAvg() {
        return this.avg;
    }

    public Double getMedian() {
        return this.median;
    }

    public Double getMax() {
        return this.max;
    }

    public Double getSum() {
        return this.sum;
    }

    public List<Percentile> getPercentiles() {
        return this.percentiles;
    }

    public Integer getSamples() {
        return this.samples;
    }

    @Override
    public boolean isEmpty() {
        return this.samples == null || this.min == null || this.avg == null || this.median == null || this.max == null || this.sum == null;
    }

    public String toString() {
        return "NumericBucketPoint[start=" + this.getStart() + ", end=" + this.getEnd() + ", min=" + this.min + ", avg=" + this.avg + ", median=" + this.median + ", max=" + this.max + ", sum=" + this.sum + ", percentiles=" + this.percentiles + ", samples=" + this.samples + ", isEmpty=" + this.isEmpty() + ']';
    }

    public static List<NumericBucketPoint> toList(Map<Long, NumericBucketPoint> pointMap, Buckets buckets) {
        return BucketPoint.toList(pointMap, buckets, (start, end) -> new Builder((long)start, (long)end).build());
    }

    public static class Builder {
        private final long start;
        private final long end;
        private double min = Double.NaN;
        private double avg = Double.NaN;
        private double median = Double.NaN;
        private double max = Double.NaN;
        private double sum = Double.NaN;
        private List<Percentile> percentiles = new ArrayList<Percentile>();
        private int samples = 0;

        public Builder(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public Builder(NumericBucketPoint numericBucketPoint) {
            this.start = numericBucketPoint.getStart();
            this.end = numericBucketPoint.getEnd();
            this.setMin(numericBucketPoint.getMin());
            this.setAvg(numericBucketPoint.getAvg());
            this.setMedian(numericBucketPoint.getMedian());
            this.setMax(numericBucketPoint.getMax());
            this.setSum(numericBucketPoint.getSum());
        }

        public Builder setMin(double min) {
            this.min = min;
            return this;
        }

        public Builder setAvg(double avg) {
            this.avg = avg;
            return this;
        }

        public Builder setMedian(double median) {
            this.median = median;
            return this;
        }

        public Builder setMax(double max) {
            this.max = max;
            return this;
        }

        public Builder setSum(double sum) {
            this.sum = sum;
            return this;
        }

        public Builder setPercentiles(List<Percentile> percentiles) {
            this.percentiles = percentiles;
            return this;
        }

        public Builder setSamples(int samples) {
            this.samples = samples;
            return this;
        }

        public NumericBucketPoint build() {
            return new NumericBucketPoint(this.start, this.end, this.min, this.avg, this.median, this.max, this.sum, this.percentiles, this.samples);
        }
    }
}

