/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Interval {
    private static final Pattern INTERVAL_PATTERN = Pattern.compile("(\\d+)(min|hr|d)");
    public static final Interval NONE = new Interval(0, null){

        @Override
        public String toString() {
            return "";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Interval interval = (Interval)o;
            return interval.length == 0 && interval.units == null;
        }

        @Override
        public int hashCode() {
            return 51;
        }
    };
    private int length;
    private Units units;

    public Interval(int length, Units units) {
        this.length = length;
        this.units = units;
    }

    public static Interval parse(String s) {
        if (s.isEmpty()) {
            return NONE;
        }
        Matcher matcher = INTERVAL_PATTERN.matcher(s);
        if (!matcher.matches() || matcher.groupCount() != 2) {
            throw new IllegalArgumentException(s + " is not a valid interval. It must follow the pattern " + INTERVAL_PATTERN.pattern());
        }
        return new Interval(Integer.parseInt(matcher.group(1)), Units.fromCode(matcher.group(2)));
    }

    public int getLength() {
        return this.length;
    }

    public Units getUnits() {
        return this.units;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interval interval = (Interval)o;
        if (this.length != interval.length) {
            return false;
        }
        return this.units == interval.units;
    }

    public int hashCode() {
        int result = this.length;
        result = 31 * result + this.units.hashCode();
        return result;
    }

    public String toString() {
        return this.length + this.units.code;
    }

    public static enum Units {
        MINUTES("min"),
        HOURS("hr"),
        DAYS("d");

        private String code;

        private Units(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }

        public static Units fromCode(String code) {
            switch (code) {
                case "min": {
                    return MINUTES;
                }
                case "hr": {
                    return HOURS;
                }
                case "d": {
                    return DAYS;
                }
            }
            throw new IllegalArgumentException(code + " is not a recognized unit");
        }
    }
}

