/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.jobs;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.datetime.DateTimeService;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.scheduler.api.JobDetails;
import org.hawkular.metrics.sysconfig.Configuration;
import org.hawkular.metrics.sysconfig.ConfigurationService;
import org.jboss.logging.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

public class CompressData
implements Func1<JobDetails, Completable> {
    private static Logger logger = Logger.getLogger(CompressData.class);
    public static final String JOB_NAME = "COMPRESS_DATA";
    public static final String BLOCK_SIZE = "compression.block.size";
    public static final String CONFIG_ID = "org.hawkular.metrics.jobs.COMPRESS_DATA";
    private static final int DEFAULT_PAGE_SIZE = 1000;
    public static final Duration DEFAULT_BLOCK_SIZE = Duration.standardHours(2L);
    private MetricsService metricsService;
    private int pageSize;
    private boolean enabled;

    public CompressData(MetricsService service, ConfigurationService configurationService) {
        this.metricsService = service;
        Configuration configuration = (Configuration)configurationService.load(CONFIG_ID).toSingle().toBlocking().value();
        this.pageSize = configuration.get("page-size") == null ? 1000 : Integer.parseInt(configuration.get("page-size"));
        String enabledConfig = configuration.get("enabled", "true");
        this.enabled = Boolean.parseBoolean(enabledConfig);
        logger.debugf("Job enabled? %b", (Object)this.enabled);
    }

    public Completable call(JobDetails jobDetails) {
        if (!this.enabled) {
            return Completable.complete();
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info((Object)"Starting execution");
        long previousBlock = DateTimeService.getTimeSlice(new DateTime(jobDetails.getTrigger().getTriggerTime(), DateTimeZone.UTC).minus(DEFAULT_BLOCK_SIZE), DEFAULT_BLOCK_SIZE).getMillis();
        Observable metricIds = this.metricsService.findAllMetricIdentifiers().filter(m -> m.getType() == MetricType.GAUGE || m.getType() == MetricType.COUNTER || m.getType() == MetricType.AVAILABILITY);
        return Completable.fromObservable((Observable)this.metricsService.compressBlock(metricIds, previousBlock, this.pageSize).doOnError(t -> logger.warn((Object)"Failed to compress data", t)).doOnCompleted(() -> {
            stopwatch.stop();
            logger.info((Object)("Finished compressing data in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
        }));
    }
}

