/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.utils.UUIDs;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.hawkular.metrics.core.service.DataAccess;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.core.service.TimeUUIDUtils;
import org.hawkular.metrics.core.service.compress.CompressedPointContainer;
import org.hawkular.metrics.core.service.transformers.BatchStatementTransformer;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Interval;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.Tenant;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.hawkular.rx.cassandra.driver.RxSessionImpl;
import rx.Observable;

public class DataAccessImpl
implements DataAccess {
    public static final long DPART = 0L;
    private Session session;
    private RxSession rxSession;
    private PreparedStatement insertTenant;
    private PreparedStatement insertTenantOverwrite;
    private PreparedStatement findAllTenantIds;
    private PreparedStatement findAllTenantIdsFromMetricsIdx;
    private PreparedStatement findTenant;
    private PreparedStatement insertIntoMetricsIndex;
    private PreparedStatement insertIntoMetricsIndexOverwrite;
    private PreparedStatement findMetricInData;
    private PreparedStatement findMetricInDataCompressed;
    private PreparedStatement findAllMetricIdsInData;
    private PreparedStatement findAllMetricIdsInDataCompressed;
    private PreparedStatement findMetricInMetricsIndex;
    private PreparedStatement findAllMetricsFromTagsIndex;
    private PreparedStatement getMetricTags;
    private PreparedStatement insertGaugeData;
    private PreparedStatement insertCompressedData;
    private PreparedStatement insertCompressedDataWithTags;
    private PreparedStatement insertGaugeDataUsingTTL;
    private PreparedStatement insertGaugeDataWithTags;
    private PreparedStatement insertGaugeDataWithTagsUsingTTL;
    private PreparedStatement insertCounterData;
    private PreparedStatement insertCounterDataUsingTTL;
    private PreparedStatement insertCounterDataWithTags;
    private PreparedStatement insertCounterDataWithTagsUsingTTL;
    private PreparedStatement insertStringData;
    private PreparedStatement insertStringDataUsingTTL;
    private PreparedStatement insertStringDataWithTags;
    private PreparedStatement insertStringDataWithTagsUsingTTL;
    private PreparedStatement findCompressedDataByDateRangeExclusive;
    private PreparedStatement findCompressedDataByDateRangeExclusiveWithLimit;
    private PreparedStatement findCompressedDataByDateRangeExclusiveASC;
    private PreparedStatement findCompressedDataByDateRangeExclusiveWithLimitASC;
    private PreparedStatement findCounterDataExclusive;
    private PreparedStatement findCounterDataExclusiveWithLimit;
    private PreparedStatement findCounterDataExclusiveASC;
    private PreparedStatement findCounterDataExclusiveWithLimitASC;
    private PreparedStatement findGaugeDataByDateRangeExclusive;
    private PreparedStatement findGaugeDataByDateRangeExclusiveWithLimit;
    private PreparedStatement findGaugeDataByDateRangeExclusiveASC;
    private PreparedStatement findGaugeDataByDateRangeExclusiveWithLimitASC;
    private PreparedStatement findStringDataByDateRangeExclusive;
    private PreparedStatement findStringDataByDateRangeExclusiveWithLimit;
    private PreparedStatement findStringDataByDateRangeExclusiveASC;
    private PreparedStatement findStringDataByDateRangeExclusiveWithLimitASC;
    private PreparedStatement findAvailabilityByDateRangeInclusive;
    private PreparedStatement deleteGaugeMetric;
    private PreparedStatement deleteDatapoints;
    private PreparedStatement insertAvailability;
    private PreparedStatement insertAvailabilityUsingTTL;
    private PreparedStatement insertAvailabilityWithTags;
    private PreparedStatement insertAvailabilityWithTagsUsingTTL;
    private PreparedStatement findAvailabilities;
    private PreparedStatement findAvailabilitiesWithLimit;
    private PreparedStatement findAvailabilitiesASC;
    private PreparedStatement findAvailabilitiesWithLimitASC;
    private PreparedStatement updateMetricsIndex;
    private PreparedStatement addTagsToMetricsIndex;
    private PreparedStatement deleteTagsFromMetricsIndex;
    private PreparedStatement readMetricsIndex;
    private PreparedStatement updateRetentionsIndex;
    private PreparedStatement findDataRetentions;
    private PreparedStatement insertMetricsTagsIndex;
    private PreparedStatement deleteMetricsTagsIndex;
    private PreparedStatement findMetricsByTagName;
    private PreparedStatement findMetricsByTagNameValue;

    public DataAccessImpl(Session session) {
        this.session = session;
        this.rxSession = new RxSessionImpl(session);
        this.initPreparedStatements();
    }

    protected void initPreparedStatements() {
        this.insertTenant = this.session.prepare("INSERT INTO tenants (id, retentions) VALUES (?, ?) IF NOT EXISTS");
        this.insertTenantOverwrite = this.session.prepare("INSERT INTO tenants (id, retentions) VALUES (?, ?)");
        this.findAllTenantIds = this.session.prepare("SELECT DISTINCT id FROM tenants");
        this.findAllTenantIdsFromMetricsIdx = this.session.prepare("SELECT DISTINCT tenant_id, type FROM metrics_idx");
        this.findTenant = this.session.prepare("SELECT id, retentions FROM tenants WHERE id = ?");
        this.findMetricInData = this.session.prepare("SELECT DISTINCT tenant_id, type, metric, dpart FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? ");
        this.findMetricInDataCompressed = this.session.prepare("SELECT DISTINCT tenant_id, type, metric, dpart FROM data_compressed WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? ");
        this.findMetricInMetricsIndex = this.session.prepare("SELECT metric, tags, data_retention FROM metrics_idx WHERE tenant_id = ? AND type = ? AND metric = ?");
        this.getMetricTags = this.session.prepare("SELECT tags FROM metrics_idx WHERE tenant_id = ? AND type = ? AND metric = ?");
        this.insertIntoMetricsIndex = this.session.prepare("INSERT INTO metrics_idx (tenant_id, type, metric, data_retention, tags) VALUES (?, ?, ?, ?, ?) IF NOT EXISTS");
        this.insertIntoMetricsIndexOverwrite = this.session.prepare("INSERT INTO metrics_idx (tenant_id, type, metric, data_retention, tags) VALUES (?, ?, ?, ?, ?) ");
        this.updateMetricsIndex = this.session.prepare("INSERT INTO metrics_idx (tenant_id, type, metric) VALUES (?, ?, ?)");
        this.addTagsToMetricsIndex = this.session.prepare("UPDATE metrics_idx SET tags = tags + ? WHERE tenant_id = ? AND type = ? AND metric = ?");
        this.deleteTagsFromMetricsIndex = this.session.prepare("UPDATE metrics_idx SET tags = tags - ?WHERE tenant_id = ? AND type = ? AND metric = ?");
        this.readMetricsIndex = this.session.prepare("SELECT metric, tags, data_retention FROM metrics_idx WHERE tenant_id = ? AND type = ? ORDER BY metric ASC");
        this.findAllMetricIdsInData = this.session.prepare("SELECT DISTINCT tenant_id, type, metric, dpart FROM data");
        this.findAllMetricIdsInDataCompressed = this.session.prepare("SELECT DISTINCT tenant_id, type, metric, dpart FROM data_compressed");
        this.findAllMetricsFromTagsIndex = this.session.prepare("SELECT tenant_id, type, metric FROM metrics_tags_idx");
        this.insertCompressedData = this.session.prepare("UPDATE data_compressed USING TTL ? SET c_value = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertCompressedDataWithTags = this.session.prepare("UPDATE data_compressed USING TTL ? SET c_value = ?, tags = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertGaugeData = this.session.prepare("UPDATE data SET n_value = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertGaugeDataUsingTTL = this.session.prepare("UPDATE data USING TTL ? SET n_value = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertGaugeDataWithTags = this.session.prepare("UPDATE data SET n_value = ?, tags = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertGaugeDataWithTagsUsingTTL = this.session.prepare("UPDATE data USING TTL ? SET n_value = ?, tags = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertStringData = this.session.prepare("UPDATE data SET s_value = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ?");
        this.insertStringDataUsingTTL = this.session.prepare("UPDATE data USING TTL ? SET s_value = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ?");
        this.insertStringDataWithTags = this.session.prepare("UPDATE data SET s_value = ?, tags = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertStringDataWithTagsUsingTTL = this.session.prepare("UPDATE data USING TTL ? SET s_value = ?, tags = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertCounterData = this.session.prepare("UPDATE data SET l_value = ?WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertCounterDataUsingTTL = this.session.prepare("UPDATE data USING TTL ? SET l_value = ?WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertCounterDataWithTags = this.session.prepare("UPDATE data SET l_value = ?, tags = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertCounterDataWithTagsUsingTTL = this.session.prepare("UPDATE data USING TTL ? SET l_value = ?, tags = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.findGaugeDataByDateRangeExclusive = this.session.prepare("SELECT time, n_value, tags FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?");
        this.findGaugeDataByDateRangeExclusiveWithLimit = this.session.prepare("SELECT time, n_value, tags FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? LIMIT ?");
        this.findGaugeDataByDateRangeExclusiveASC = this.session.prepare("SELECT time, n_value, tags FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ORDER BY time ASC");
        this.findGaugeDataByDateRangeExclusiveWithLimitASC = this.session.prepare("SELECT time, n_value, tags FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ORDER BY time ASC LIMIT ?");
        this.findCompressedDataByDateRangeExclusive = this.session.prepare("SELECT time, c_value, tags FROM data_compressed WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?");
        this.findCompressedDataByDateRangeExclusiveWithLimit = this.session.prepare("SELECT time, c_value, tags FROM data_compressed  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? LIMIT ?");
        this.findCompressedDataByDateRangeExclusiveASC = this.session.prepare("SELECT time, c_value, tags FROM data_compressed WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ORDER BY time ASC");
        this.findCompressedDataByDateRangeExclusiveWithLimitASC = this.session.prepare("SELECT time, c_value, tags FROM data_compressed WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ORDER BY time ASC LIMIT ?");
        this.findStringDataByDateRangeExclusive = this.session.prepare("SELECT time, s_value, tags FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?");
        this.findStringDataByDateRangeExclusiveWithLimit = this.session.prepare("SELECT time, s_value, tags FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? LIMIT ?");
        this.findStringDataByDateRangeExclusiveASC = this.session.prepare("SELECT time, s_value, tags FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ORDER BY time ASC");
        this.findStringDataByDateRangeExclusiveWithLimitASC = this.session.prepare("SELECT time, s_value, tags FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ORDER BY time ASC LIMIT ?");
        this.findCounterDataExclusive = this.session.prepare("SELECT time, l_value, tags FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ");
        this.findCounterDataExclusiveWithLimit = this.session.prepare("SELECT time, l_value, tags FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?  LIMIT ?");
        this.findCounterDataExclusiveASC = this.session.prepare("SELECT time, l_value, tags FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ORDER BY time ASC");
        this.findCounterDataExclusiveWithLimitASC = this.session.prepare("SELECT time, l_value, tags FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?  ORDER BY time ASC LIMIT ?");
        this.findAvailabilityByDateRangeInclusive = this.session.prepare("SELECT time, availability, WRITETIME(availability) FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time <= ?");
        this.deleteGaugeMetric = this.session.prepare("DELETE FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ?");
        this.deleteDatapoints = this.session.prepare("DELETE FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?");
        this.insertAvailability = this.session.prepare("UPDATE data SET availability = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ?");
        this.insertAvailabilityUsingTTL = this.session.prepare("UPDATE data USING TTL ? SET availability = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ?");
        this.insertAvailabilityWithTags = this.session.prepare("UPDATE data SET availability = ?, tags = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ?");
        this.insertAvailabilityWithTagsUsingTTL = this.session.prepare("UPDATE data USING TTL ? SET availability = ?, tags = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ?");
        this.findAvailabilities = this.session.prepare("SELECT time, availability, tags  FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ");
        this.findAvailabilitiesWithLimit = this.session.prepare("SELECT time, availability, tags  FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?  LIMIT ?");
        this.findAvailabilitiesASC = this.session.prepare("SELECT time, availability, tags  FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?  ORDER BY time ASC");
        this.findAvailabilitiesWithLimitASC = this.session.prepare("SELECT time, availability, tags  FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?  ORDER BY time ASC LIMIT ?");
        this.updateRetentionsIndex = this.session.prepare("INSERT INTO retentions_idx (tenant_id, type, metric, retention) VALUES (?, ?, ?, ?)");
        this.findDataRetentions = this.session.prepare("SELECT tenant_id, type, metric, retention FROM retentions_idx WHERE tenant_id = ? AND type = ?");
        this.insertMetricsTagsIndex = this.session.prepare("INSERT INTO metrics_tags_idx (tenant_id, tname, tvalue, type, metric) VALUES (?, ?, ?, ?, ?)");
        this.deleteMetricsTagsIndex = this.session.prepare("DELETE FROM metrics_tags_idx WHERE tenant_id = ? AND tname = ? AND tvalue = ? AND type = ? AND metric = ?");
        this.findMetricsByTagName = this.session.prepare("SELECT tenant_id, type, metric, tvalue FROM metrics_tags_idx WHERE tenant_id = ? AND tname = ?");
        this.findMetricsByTagNameValue = this.session.prepare("SELECT tenant_id, type, metric FROM metrics_tags_idx WHERE tenant_id = ? AND tname = ? AND tvalue = ?");
    }

    @Override
    public Observable<ResultSet> insertTenant(Tenant tenant, boolean overwrite) {
        Map<String, Integer> retentions = tenant.getRetentionSettings().entrySet().stream().collect(Collectors.toMap(entry -> ((MetricType)entry.getKey()).getText(), Map.Entry::getValue));
        if (overwrite) {
            return this.rxSession.execute((Statement)this.insertTenantOverwrite.bind(tenant.getId(), retentions));
        }
        return this.rxSession.execute((Statement)this.insertTenant.bind(tenant.getId(), retentions));
    }

    @Override
    public Observable<Row> findAllTenantIds() {
        return this.rxSession.executeAndFetch((Statement)this.findAllTenantIds.bind()).concatWith(this.rxSession.executeAndFetch((Statement)this.findAllTenantIdsFromMetricsIdx.bind()));
    }

    @Override
    public Observable<Row> findTenant(String id) {
        return this.rxSession.executeAndFetch((Statement)this.findTenant.bind(id));
    }

    @Override
    public <T> ResultSetFuture insertMetricInMetricsIndex(Metric<T> metric, boolean overwrite) {
        MetricId<T> metricId = metric.getMetricId();
        if (overwrite) {
            return this.session.executeAsync(this.insertIntoMetricsIndexOverwrite.bind(metricId.getTenantId(), metricId.getType().getCode(), metricId.getName(), metric.getDataRetention(), metric.getTags()));
        }
        return this.session.executeAsync(this.insertIntoMetricsIndex.bind(metricId.getTenantId(), metricId.getType().getCode(), metricId.getName(), metric.getDataRetention(), metric.getTags()));
    }

    @Override
    public <T> Observable<Row> findMetricInData(MetricId<T> id) {
        return this.rxSession.executeAndFetch((Statement)this.findMetricInData.bind(id.getTenantId(), id.getType().getCode(), id.getName(), 0L)).concatWith(this.rxSession.executeAndFetch((Statement)this.findMetricInDataCompressed.bind(id.getTenantId(), id.getType().getCode(), id.getName(), 0L))).take(1);
    }

    @Override
    public <T> Observable<Row> findMetricInMetricsIndex(MetricId<T> id) {
        return this.rxSession.executeAndFetch((Statement)this.findMetricInMetricsIndex.bind(id.getTenantId(), id.getType().getCode(), id.getName()));
    }

    @Override
    public <T> Observable<Row> getMetricTags(MetricId<T> id) {
        return this.rxSession.executeAndFetch((Statement)this.getMetricTags.bind(id.getTenantId(), id.getType().getCode(), id.getName()));
    }

    @Override
    public <T> Observable<ResultSet> addTags(Metric<T> metric, Map<String, String> tags) {
        MetricId<T> metricId = metric.getMetricId();
        BoundStatement stmt = this.addTagsToMetricsIndex.bind(tags, metricId.getTenantId(), metricId.getType().getCode(), metricId.getName());
        return this.rxSession.execute((Statement)stmt);
    }

    @Override
    public <T> Observable<ResultSet> deleteTags(Metric<T> metric, Set<String> tags) {
        MetricId<T> metricId = metric.getMetricId();
        BoundStatement stmt = this.deleteTagsFromMetricsIndex.bind(tags, metricId.getTenantId(), metricId.getType().getCode(), metricId.getName());
        return this.rxSession.execute((Statement)stmt);
    }

    @Override
    public <T> Observable<Integer> updateMetricsIndex(Observable<Metric<T>> metrics) {
        return metrics.map(Metric::getMetricId).map(id -> this.updateMetricsIndex.bind(id.getTenantId(), id.getType().getCode(), id.getName())).compose((Observable.Transformer)new BatchStatementTransformer()).flatMap(batch -> this.rxSession.execute((Statement)batch).map(resultSet -> batch.size()));
    }

    @Override
    public <T> Observable<Row> findMetricsInMetricsIndex(String tenantId, MetricType<T> type) {
        return this.rxSession.executeAndFetch((Statement)this.readMetricsIndex.bind(tenantId, type.getCode()));
    }

    @Override
    public Observable<Row> findAllMetricIdentifiersInData() {
        return this.rxSession.executeAndFetch((Statement)this.findAllMetricIdsInData.bind()).concatWith(this.rxSession.executeAndFetch((Statement)this.findAllMetricIdsInDataCompressed.bind()));
    }

    @Override
    public Observable<Integer> insertGaugeData(Metric<Double> gauge) {
        return this.insertGaugeData(gauge, -1);
    }

    @Override
    public Observable<Integer> insertGaugeData(Metric<Double> gauge, int ttl) {
        return Observable.from(gauge.getDataPoints()).map(dataPoint -> {
            if (dataPoint.getTags().isEmpty()) {
                if (ttl >= 0) {
                    return this.bindDataPoint(this.insertGaugeDataUsingTTL, gauge, dataPoint.getValue(), dataPoint.getTimestamp(), ttl);
                }
                return this.bindDataPoint(this.insertGaugeData, gauge, dataPoint.getValue(), dataPoint.getTimestamp());
            }
            if (ttl >= 0) {
                return this.bindDataPoint(this.insertGaugeDataWithTagsUsingTTL, gauge, dataPoint.getValue(), dataPoint.getTags(), dataPoint.getTimestamp(), ttl);
            }
            return this.bindDataPoint(this.insertGaugeDataWithTags, gauge, dataPoint.getValue(), dataPoint.getTags(), dataPoint.getTimestamp());
        }).compose((Observable.Transformer)new BatchStatementTransformer()).flatMap(batch -> this.rxSession.execute((Statement)batch).map(resultSet -> batch.size()));
    }

    @Override
    public Observable<Integer> insertStringData(Metric<String> metric, int maxSize) {
        return this.insertStringData(metric, -1, maxSize);
    }

    @Override
    public Observable<Integer> insertStringData(Metric<String> metric, int ttl, int maxSize) {
        return Observable.from(metric.getDataPoints()).map(dataPoint -> {
            if (maxSize != -1 && ((String)dataPoint.getValue()).length() > maxSize) {
                throw new IllegalArgumentException(dataPoint + " exceeds max string length of " + maxSize + " characters");
            }
            if (dataPoint.getTags().isEmpty()) {
                if (ttl >= 0) {
                    return this.bindDataPoint(this.insertStringDataUsingTTL, metric, dataPoint.getValue(), dataPoint.getTimestamp(), ttl);
                }
                return this.bindDataPoint(this.insertStringData, metric, dataPoint.getValue(), dataPoint.getTimestamp());
            }
            if (ttl >= 0) {
                return this.bindDataPoint(this.insertStringDataWithTagsUsingTTL, metric, dataPoint.getValue(), dataPoint.getTags(), dataPoint.getTimestamp(), ttl);
            }
            return this.bindDataPoint(this.insertStringDataWithTags, metric, dataPoint.getValue(), dataPoint.getTags(), dataPoint.getTimestamp());
        }).compose((Observable.Transformer)new BatchStatementTransformer()).flatMap(batch -> this.rxSession.execute((Statement)batch).map(resultSet -> batch.size()));
    }

    @Override
    public Observable<Integer> insertCounterData(Metric<Long> counter) {
        return this.insertCounterData(counter, -1);
    }

    @Override
    public Observable<Integer> insertCounterData(Metric<Long> counter, int ttl) {
        return Observable.from(counter.getDataPoints()).map(dataPoint -> {
            if (dataPoint.getTags().isEmpty()) {
                if (ttl >= 0) {
                    return this.bindDataPoint(this.insertCounterDataUsingTTL, counter, dataPoint.getValue(), dataPoint.getTimestamp(), ttl);
                }
                return this.bindDataPoint(this.insertCounterData, counter, dataPoint.getValue(), dataPoint.getTimestamp());
            }
            if (ttl >= 0) {
                return this.bindDataPoint(this.insertCounterDataWithTagsUsingTTL, counter, dataPoint.getValue(), dataPoint.getTags(), dataPoint.getTimestamp(), ttl);
            }
            return this.bindDataPoint(this.insertCounterDataWithTags, counter, dataPoint.getValue(), dataPoint.getTags(), dataPoint.getTimestamp());
        }).compose((Observable.Transformer)new BatchStatementTransformer()).flatMap(batch -> this.rxSession.execute((Statement)batch).map(resultSet -> batch.size()));
    }

    private BoundStatement bindDataPoint(PreparedStatement statement, Metric<?> metric, Object value, long timestamp) {
        MetricId<?> metricId = metric.getMetricId();
        return statement.bind(value, metricId.getTenantId(), metricId.getType().getCode(), metricId.getName(), 0L, TimeUUIDUtils.getTimeUUID(timestamp));
    }

    private BoundStatement bindDataPoint(PreparedStatement statement, Metric<?> metric, Object value, long timestamp, int ttl) {
        MetricId<?> metricId = metric.getMetricId();
        return statement.bind(ttl, value, metricId.getTenantId(), metricId.getType().getCode(), metricId.getName(), 0L, TimeUUIDUtils.getTimeUUID(timestamp));
    }

    private BoundStatement bindDataPoint(PreparedStatement statement, Metric<?> metric, Object value, Map<String, String> tags, long timestamp) {
        MetricId<?> metricId = metric.getMetricId();
        return statement.bind(value, tags, metricId.getTenantId(), metricId.getType().getCode(), metricId.getName(), 0L, TimeUUIDUtils.getTimeUUID(timestamp));
    }

    private BoundStatement bindDataPoint(PreparedStatement statement, Metric<?> metric, Object value, Map<String, String> tags, long timestamp, int ttl) {
        MetricId<?> metricId = metric.getMetricId();
        return statement.bind(ttl, value, tags, metricId.getTenantId(), metricId.getType().getCode(), metricId.getName(), 0L, TimeUUIDUtils.getTimeUUID(timestamp));
    }

    @Override
    public Observable<Row> findCounterData(MetricId<Long> id, long startTime, long endTime, int limit, Order order, int pageSize) {
        if (order == Order.ASC) {
            if (limit <= 0) {
                return this.rxSession.executeAndFetch(this.findCounterDataExclusiveASC.bind(id.getTenantId(), MetricType.COUNTER.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)).setFetchSize(pageSize));
            }
            return this.rxSession.executeAndFetch(this.findCounterDataExclusiveWithLimitASC.bind(id.getTenantId(), MetricType.COUNTER.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit).setFetchSize(pageSize));
        }
        if (limit <= 0) {
            return this.rxSession.executeAndFetch(this.findCounterDataExclusive.bind(id.getTenantId(), MetricType.COUNTER.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)).setFetchSize(pageSize));
        }
        return this.rxSession.executeAndFetch(this.findCounterDataExclusiveWithLimit.bind(id.getTenantId(), MetricType.COUNTER.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit).setFetchSize(pageSize));
    }

    @Override
    public Observable<Row> findCompressedData(MetricId<?> id, long startTime, long endTime, int limit, Order order) {
        if (order == Order.ASC) {
            if (limit <= 0) {
                return this.rxSession.executeAndFetch((Statement)this.findCompressedDataByDateRangeExclusiveASC.bind(id.getTenantId(), id.getType().getCode(), id.getName(), 0L, new Date(startTime), new Date(endTime)));
            }
            return this.rxSession.executeAndFetch((Statement)this.findCompressedDataByDateRangeExclusiveWithLimitASC.bind(id.getTenantId(), id.getType().getCode(), id.getName(), 0L, new Date(startTime), new Date(endTime), limit));
        }
        if (limit <= 0) {
            return this.rxSession.executeAndFetch((Statement)this.findCompressedDataByDateRangeExclusive.bind(id.getTenantId(), id.getType().getCode(), id.getName(), 0L, new Date(startTime), new Date(endTime)));
        }
        return this.rxSession.executeAndFetch((Statement)this.findCompressedDataByDateRangeExclusiveWithLimit.bind(id.getTenantId(), id.getType().getCode(), id.getName(), 0L, new Date(startTime), new Date(endTime), limit));
    }

    @Override
    public Observable<Row> findGaugeData(MetricId<Double> id, long startTime, long endTime, int limit, Order order, int pageSize) {
        if (order == Order.ASC) {
            if (limit <= 0) {
                return this.rxSession.executeAndFetch(this.findGaugeDataByDateRangeExclusiveASC.bind(id.getTenantId(), MetricType.GAUGE.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)).setFetchSize(pageSize));
            }
            return this.rxSession.executeAndFetch(this.findGaugeDataByDateRangeExclusiveWithLimitASC.bind(id.getTenantId(), MetricType.GAUGE.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit).setFetchSize(pageSize));
        }
        if (limit <= 0) {
            return this.rxSession.executeAndFetch(this.findGaugeDataByDateRangeExclusive.bind(id.getTenantId(), MetricType.GAUGE.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)).setFetchSize(pageSize));
        }
        return this.rxSession.executeAndFetch(this.findGaugeDataByDateRangeExclusiveWithLimit.bind(id.getTenantId(), MetricType.GAUGE.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit).setFetchSize(pageSize));
    }

    @Override
    public Observable<Row> findStringData(MetricId<String> id, long startTime, long endTime, int limit, Order order, int pageSize) {
        if (order == Order.ASC) {
            if (limit <= 0) {
                return this.rxSession.executeAndFetch(this.findStringDataByDateRangeExclusiveASC.bind(id.getTenantId(), MetricType.STRING.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)).setFetchSize(pageSize));
            }
            return this.rxSession.executeAndFetch(this.findStringDataByDateRangeExclusiveWithLimitASC.bind(id.getTenantId(), MetricType.STRING.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit).setFetchSize(pageSize));
        }
        if (limit <= 0) {
            return this.rxSession.executeAndFetch(this.findStringDataByDateRangeExclusive.bind(id.getTenantId(), MetricType.STRING.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)).setFetchSize(pageSize));
        }
        return this.rxSession.executeAndFetch(this.findStringDataByDateRangeExclusiveWithLimit.bind(id.getTenantId(), MetricType.STRING.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit).setFetchSize(pageSize));
    }

    @Override
    public Observable<Row> findAvailabilityData(MetricId<AvailabilityType> id, long startTime, long endTime, int limit, Order order, int pageSize) {
        if (order == Order.ASC) {
            if (limit <= 0) {
                return this.rxSession.executeAndFetch(this.findAvailabilitiesASC.bind(id.getTenantId(), MetricType.AVAILABILITY.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)).setFetchSize(pageSize));
            }
            return this.rxSession.executeAndFetch(this.findAvailabilitiesWithLimitASC.bind(id.getTenantId(), MetricType.AVAILABILITY.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit).setFetchSize(pageSize));
        }
        if (limit <= 0) {
            return this.rxSession.executeAndFetch(this.findAvailabilities.bind(id.getTenantId(), MetricType.AVAILABILITY.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)).setFetchSize(pageSize));
        }
        return this.rxSession.executeAndFetch(this.findAvailabilitiesWithLimit.bind(id.getTenantId(), MetricType.AVAILABILITY.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit).setFetchSize(pageSize));
    }

    @Override
    public Observable<Row> findAvailabilityData(MetricId<AvailabilityType> id, long timestamp) {
        return this.rxSession.executeAndFetch((Statement)this.findAvailabilityByDateRangeInclusive.bind(id.getTenantId(), MetricType.AVAILABILITY.getCode(), id.getName(), 0L, UUIDs.startOf(timestamp), UUIDs.endOf(timestamp)));
    }

    @Override
    public Observable<ResultSet> deleteGaugeMetric(String tenantId, String metric, Interval interval, long dpart) {
        return this.rxSession.execute((Statement)this.deleteGaugeMetric.bind(tenantId, MetricType.GAUGE.getCode(), metric, interval.toString(), dpart));
    }

    @Override
    public Observable<Integer> insertAvailabilityData(Metric<AvailabilityType> metric) {
        return this.insertAvailabilityData(metric, -1);
    }

    @Override
    public Observable<Integer> insertAvailabilityData(Metric<AvailabilityType> metric, int ttl) {
        return Observable.from(metric.getDataPoints()).map(dataPoint -> {
            if (dataPoint.getTags().isEmpty()) {
                if (ttl >= 0) {
                    return this.bindDataPoint(this.insertAvailabilityUsingTTL, metric, (Object)this.getBytes((DataPoint<AvailabilityType>)dataPoint), dataPoint.getTimestamp(), ttl);
                }
                return this.bindDataPoint(this.insertAvailability, metric, this.getBytes((DataPoint<AvailabilityType>)dataPoint), dataPoint.getTimestamp());
            }
            if (ttl >= 0) {
                return this.bindDataPoint(this.insertAvailabilityWithTagsUsingTTL, metric, this.getBytes((DataPoint<AvailabilityType>)dataPoint), dataPoint.getTags(), dataPoint.getTimestamp(), ttl);
            }
            return this.bindDataPoint(this.insertAvailabilityWithTags, metric, (Object)this.getBytes((DataPoint<AvailabilityType>)dataPoint), dataPoint.getTags(), dataPoint.getTimestamp());
        }).compose((Observable.Transformer)new BatchStatementTransformer()).flatMap(batch -> this.rxSession.execute((Statement)batch).map(resultSet -> batch.size()));
    }

    private ByteBuffer getBytes(DataPoint<AvailabilityType> dataPoint) {
        return ByteBuffer.wrap(new byte[]{dataPoint.getValue().getCode()});
    }

    @Override
    public <T> ResultSetFuture findDataRetentions(String tenantId, MetricType<T> type) {
        return this.session.executeAsync(this.findDataRetentions.bind(tenantId, type.getCode()));
    }

    @Override
    public <T> Observable<ResultSet> updateRetentionsIndex(String tenantId, MetricType<T> type, Map<String, Integer> retentions) {
        return Observable.from(retentions.entrySet()).map(entry -> this.updateRetentionsIndex.bind(tenantId, type.getCode(), entry.getKey(), entry.getValue())).compose((Observable.Transformer)new BatchStatementTransformer()).flatMap(arg_0 -> ((RxSession)this.rxSession).execute(arg_0));
    }

    @Override
    public <T> Observable<ResultSet> insertIntoMetricsTagsIndex(Metric<T> metric, Map<String, String> tags) {
        MetricId metricId = metric.getMetricId();
        return this.tagsUpdates(tags, (name, value) -> this.insertMetricsTagsIndex.bind(metricId.getTenantId(), name, value, metricId.getType().getCode(), metricId.getName()));
    }

    @Override
    public <T> Observable<ResultSet> deleteFromMetricsTagsIndex(Metric<T> metric, Map<String, String> tags) {
        MetricId metricId = metric.getMetricId();
        return this.tagsUpdates(tags, (name, value) -> this.deleteMetricsTagsIndex.bind(metricId.getTenantId(), name, value, metricId.getType().getCode(), metricId.getName()));
    }

    private Observable<ResultSet> tagsUpdates(Map<String, String> tags, BiFunction<String, String, BoundStatement> bindVars) {
        return Observable.from(tags.entrySet()).map(entry -> (BoundStatement)bindVars.apply((String)entry.getKey(), (String)entry.getValue())).flatMap(arg_0 -> ((RxSession)this.rxSession).execute(arg_0));
    }

    @Override
    public Observable<Row> findMetricsByTagName(String tenantId, String tag) {
        return this.rxSession.executeAndFetch((Statement)this.findMetricsByTagName.bind(tenantId, tag));
    }

    @Override
    public Observable<Row> findMetricsByTagNameValue(String tenantId, String tag, String tvalue) {
        return this.rxSession.executeAndFetch((Statement)this.findMetricsByTagNameValue.bind(tenantId, tag, tvalue));
    }

    @Override
    public <T> ResultSetFuture updateRetentionsIndex(Metric<T> metric) {
        return this.session.executeAsync(this.updateRetentionsIndex.bind(metric.getMetricId().getTenantId(), metric.getMetricId().getType().getCode(), metric.getMetricId().getName(), metric.getDataRetention()));
    }

    @Override
    public <T> Observable<ResultSet> deleteAndInsertCompressedGauge(MetricId<T> id, long timeslice, CompressedPointContainer cpc, long sliceStart, long sliceEnd, int ttl) {
        BoundStatement b2;
        Observable.just((Object)cpc.getValueBuffer(), (Object)cpc.getTimestampBuffer(), (Object)cpc.getTagsBuffer()).doOnNext(bb -> {
            if (bb != null && bb.position() != 0) {
                bb.rewind();
            }
        });
        BiConsumer<BoundStatement, Integer> mapper = (b, i) -> b.setString((int)i, id.getTenantId()).setByte(i + 1, id.getType().getCode()).setString(i + 2, id.getName()).setLong(i + 3, 0L).setTimestamp(i + 4, new Date(timeslice));
        int i2 = 0;
        if (cpc.getTagsBuffer() != null) {
            b2 = this.insertCompressedDataWithTags.bind().setInt(i2, ttl).setBytes(i2 + 1, cpc.getValueBuffer()).setBytes(i2 + 2, cpc.getTagsBuffer());
            mapper.accept(b2, 3);
        } else {
            b2 = this.insertCompressedData.bind().setInt(i2, ttl).setBytes(i2 + 1, cpc.getValueBuffer());
            mapper.accept(b2, 2);
        }
        return Observable.just((Object)this.deleteDatapoints.bind().setString(0, id.getTenantId()).setByte(1, id.getType().getCode()).setString(2, id.getName()).setLong(3, 0L).setUUID(4, TimeUUIDUtils.getTimeUUID(sliceStart)).setUUID(5, TimeUUIDUtils.getTimeUUID(sliceEnd))).concatWith(Observable.just((Object)b2)).concatMap(st -> this.rxSession.execute((Statement)st));
    }

    @Override
    public Observable<Row> findAllMetricsFromTagsIndex() {
        return this.rxSession.executeAndFetch((Statement)this.findAllMetricsFromTagsIndex.bind());
    }
}

