/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.hawkular.metrics.core.service.DataAccess;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.PatternUtil;
import org.hawkular.metrics.core.service.transformers.ItemsToSetTransformer;
import org.hawkular.metrics.core.service.transformers.TagsIndexRowTransformer;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import rx.Observable;
import rx.functions.Func1;

public class TagQueryParser {
    private DataAccess dataAccess;
    private MetricsService metricsService;

    public TagQueryParser(DataAccess dataAccess, MetricsService metricsService) {
        this.dataAccess = dataAccess;
        this.metricsService = metricsService;
    }

    public Observable<MetricId<?>> findMetricIdentifiersWithFilters(String tenantId, MetricType<?> metricType, Map<String, String> tagsQueries) {
        Map<Long, List<Map.Entry<String, String>>> costSortedMap = QueryOptimizer.reOrderTagsQuery(tagsQueries);
        List<Map.Entry<String, String>> groupBEntries = costSortedMap.get(50L);
        List<Map.Entry<String, String>> groupCEntries = costSortedMap.get(99L);
        Observable groupMetrics = Observable.from(groupBEntries).flatMap(e -> this.dataAccess.findMetricsByTagName(tenantId, (String)e.getKey()).filter(this.tagValueFilter((String)e.getValue(), 3)).compose(new TagsIndexRowTransformer(metricType)).compose(new ItemsToSetTransformer()).reduce((s1, s2) -> {
            s1.addAll(s2);
            return s1;
        })).reduce((s1, s2) -> {
            s1.retainAll((Collection<?>)s2);
            return s1;
        }).flatMap(Observable::from);
        if (groupBEntries.isEmpty() && !groupCEntries.isEmpty()) {
            Observable tagsMetrics = this.dataAccess.findAllMetricsFromTagsIndex().compose(new TagsIndexRowTransformer(metricType)).filter(mId -> mId.getTenantId().equals(tenantId));
            Observable dataMetrics = this.metricsService.findAllMetricIdentifiers().filter(m -> m.getTenantId().equals(tenantId)).filter(this.metricTypeFilter(metricType));
            groupMetrics = Observable.concat((Observable)tagsMetrics, (Observable)dataMetrics).distinct();
        }
        if (groupCEntries.size() > 0) {
            Observable metrics = groupMetrics.flatMap(this.metricsService::findMetric);
            for (Map.Entry<String, String> groupCQuery : groupCEntries) {
                metrics = metrics.filter(this.tagNotExistsFilter(groupCQuery.getKey().substring(1)));
            }
            groupMetrics = metrics.map(Metric::getMetricId);
        }
        return groupMetrics;
    }

    public Observable<Map<String, Set<String>>> getTagValues(String tenantId, MetricType<?> metricType, Map<String, String> tagsQueries) {
        return Observable.from(tagsQueries.entrySet()).flatMap(e -> this.dataAccess.findMetricsByTagName(tenantId, (String)e.getKey()).filter(this.typeFilter(metricType)).filter(this.tagValueFilter((String)e.getValue(), 3)).map(row -> {
            HashMap idMap = new HashMap();
            HashMap valueMap = new HashMap();
            valueMap.put(e.getKey(), row.getString(3));
            idMap.put(row.getString(2), valueMap);
            return idMap;
        }).switchIfEmpty(Observable.just(new HashMap())).reduce((map1, map2) -> {
            map1.putAll(map2);
            return map1;
        })).reduce((m1, m2) -> {
            Iterator iterator = m1.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (!m2.containsKey(next.getKey())) {
                    iterator.remove();
                    continue;
                }
                Map map2 = (Map)m2.get(next.getKey());
                map2.forEach((k, v) -> ((Map)next.getValue()).put(k, v));
            }
            return m1;
        }).map(m -> {
            HashMap tagValueMap = new HashMap();
            m.forEach((k, v) -> v.forEach((subKey, subValue) -> {
                if (tagValueMap.containsKey(subKey)) {
                    ((Set)tagValueMap.get(subKey)).add(subValue);
                } else {
                    HashSet<String> values = new HashSet<String>();
                    values.add((String)subValue);
                    tagValueMap.put(subKey, values);
                }
            }));
            return tagValueMap;
        });
    }

    private Func1<Metric<?>, Boolean> tagNotExistsFilter(String unwantedTagName) {
        return tMetric -> !tMetric.getTags().keySet().contains(unwantedTagName);
    }

    private Func1<Row, Boolean> tagValueFilter(String regexp, int index) {
        boolean positive = !regexp.startsWith("!");
        Pattern p = PatternUtil.filterPattern(regexp);
        return r -> positive == p.matcher(r.getString(index)).matches();
    }

    public Func1<Row, Boolean> typeFilter(MetricType<?> type) {
        return row -> {
            MetricType<?> metricType = MetricType.fromCode(row.getByte(1));
            return type == null && metricType.isUserType() || metricType == type;
        };
    }

    public Func1<MetricId<?>, Boolean> metricTypeFilter(MetricType<?> type) {
        return tMetric -> type == null && tMetric.getType().isUserType() || tMetric.getType() == type;
    }

    static class QueryOptimizer {
        public static final long GROUP_A_COST = 10L;
        public static final long GROUP_B_COST = 50L;
        public static final long GROUP_C_COST = 99L;

        QueryOptimizer() {
        }

        public static Map<Long, List<Map.Entry<String, String>>> reOrderTagsQuery(Map<String, String> tagsQuery) {
            TreeMap<Long, List<Map.Entry<String, String>>> costSortedMap = new TreeMap<Long, List<Map.Entry<String, String>>>();
            costSortedMap.put(50L, new ArrayList());
            costSortedMap.put(99L, new ArrayList());
            for (Map.Entry<String, String> tagQuery : tagsQuery.entrySet()) {
                List entries;
                if (tagQuery.getKey().startsWith("!")) {
                    entries = (List)costSortedMap.get(99L);
                    entries.add(tagQuery);
                    continue;
                }
                entries = (List)costSortedMap.get(50L);
                entries.add(tagQuery);
            }
            return costSortedMap;
        }
    }
}

